# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DSVM_LINPREDICT_METADATA = Metadata(
    id="0dff3a78cf5e724eaa03100a73cf96116889b8fb.boutiques",
    name="3dsvm_linpredict",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dsvmLinpredictParameters = typing.TypedDict('V3dsvmLinpredictParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dsvm_linpredict"]],
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "weight_vector": InputPathType,
    "input_dataset": str,
})
V3dsvmLinpredictParametersTagged = typing.TypedDict('V3dsvmLinpredictParametersTagged', {
    "@type": typing.Literal["afni/3dsvm_linpredict"],
    "mask_dataset": typing.NotRequired[InputPathType | None],
    "weight_vector": InputPathType,
    "input_dataset": str,
})


class V3dsvmLinpredictOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dsvmLinpredictParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    stdout_output: OutputPathType
    """The result is a number printed to stdout"""


def v_3dsvm_linpredict_params(
    weight_vector: InputPathType,
    input_dataset: str,
    mask_dataset: InputPathType | None = None,
) -> V3dsvmLinpredictParametersTagged:
    """
    Build parameters.
    
    Args:
        weight_vector: Weight vector dataset.
        input_dataset: Input dataset, potentially with sub-brick and/or\
            sub-range selectors.
        mask_dataset: Dataset to be used as a mask. Only voxels with nonzero\
            values in 'mset' will be averaged from 'dataset'. The mask dataset and\
            the input dataset must have the same number of voxels.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dsvm_linpredict",
        "weight_vector": weight_vector,
        "input_dataset": input_dataset,
    }
    if mask_dataset is not None:
        params["mask_dataset"] = mask_dataset
    return params


def v_3dsvm_linpredict_cargs(
    params: V3dsvmLinpredictParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dsvm_linpredict")
    if params.get("mask_dataset", None) is not None:
        cargs.extend([
            "-mask",
            execution.input_file(params.get("mask_dataset", None))
        ])
    cargs.append(execution.input_file(params.get("weight_vector", None)))
    cargs.append(params.get("input_dataset", None))
    return cargs


def v_3dsvm_linpredict_outputs(
    params: V3dsvmLinpredictParameters,
    execution: Execution,
) -> V3dsvmLinpredictOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dsvmLinpredictOutputs(
        root=execution.output_file("."),
        stdout_output=execution.output_file("stdout"),
    )
    return ret


def v_3dsvm_linpredict_execute(
    params: V3dsvmLinpredictParameters,
    runner: Runner | None = None,
) -> V3dsvmLinpredictOutputs:
    """
    3dsvm_linpredict
    
    Linear prediction for weights from 3dsvm.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dsvmLinpredictOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DSVM_LINPREDICT_METADATA)
    params = execution.params(params)
    cargs = v_3dsvm_linpredict_cargs(params, execution)
    ret = v_3dsvm_linpredict_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dsvm_linpredict(
    weight_vector: InputPathType,
    input_dataset: str,
    mask_dataset: InputPathType | None = None,
    runner: Runner | None = None,
) -> V3dsvmLinpredictOutputs:
    """
    3dsvm_linpredict
    
    Linear prediction for weights from 3dsvm.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        weight_vector: Weight vector dataset.
        input_dataset: Input dataset, potentially with sub-brick and/or\
            sub-range selectors.
        mask_dataset: Dataset to be used as a mask. Only voxels with nonzero\
            values in 'mset' will be averaged from 'dataset'. The mask dataset and\
            the input dataset must have the same number of voxels.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dsvmLinpredictOutputs`).
    """
    params = v_3dsvm_linpredict_params(
        mask_dataset=mask_dataset,
        weight_vector=weight_vector,
        input_dataset=input_dataset,
    )
    return v_3dsvm_linpredict_execute(params, runner)


__all__ = [
    "V3dsvmLinpredictOutputs",
    "V_3DSVM_LINPREDICT_METADATA",
    "v_3dsvm_linpredict",
    "v_3dsvm_linpredict_execute",
    "v_3dsvm_linpredict_params",
]
