# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DTO_XDATASET_METADATA = Metadata(
    id="d2eac774e19a889458cfb0fa5143f310fa015e21.boutiques",
    name="3dtoXdataset",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dtoXdatasetParameters = typing.TypedDict('V3dtoXdatasetParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dtoXdataset"]],
    "prefix": str,
    "mask": InputPathType,
    "input_files": list[InputPathType],
})
V3dtoXdatasetParametersTagged = typing.TypedDict('V3dtoXdatasetParametersTagged', {
    "@type": typing.Literal["afni/3dtoXdataset"],
    "prefix": str,
    "mask": InputPathType,
    "input_files": list[InputPathType],
})


class V3dtoXdatasetOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dtoXdatasetParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_sdat: OutputPathType
    """Output file in .sdat format"""


def v_3dto_xdataset_params(
    prefix: str,
    mask: InputPathType,
    input_files: list[InputPathType],
) -> V3dtoXdatasetParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for the output file.
        mask: Mask dataset file.
        input_files: Input datasets to be converted.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dtoXdataset",
        "prefix": prefix,
        "mask": mask,
        "input_files": input_files,
    }
    return params


def v_3dto_xdataset_cargs(
    params: V3dtoXdatasetParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dtoXdataset")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.append(execution.input_file(params.get("mask", None)))
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def v_3dto_xdataset_outputs(
    params: V3dtoXdatasetParameters,
    execution: Execution,
) -> V3dtoXdatasetOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dtoXdatasetOutputs(
        root=execution.output_file("."),
        output_sdat=execution.output_file(params.get("prefix", None) + ".sdat"),
    )
    return ret


def v_3dto_xdataset_execute(
    params: V3dtoXdatasetParameters,
    runner: Runner | None = None,
) -> V3dtoXdatasetOutputs:
    """
    3dtoXdataset
    
    Convert input datasets to the format needed for 3dClustSimX.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dtoXdatasetOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DTO_XDATASET_METADATA)
    params = execution.params(params)
    cargs = v_3dto_xdataset_cargs(params, execution)
    ret = v_3dto_xdataset_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dto_xdataset(
    prefix: str,
    mask: InputPathType,
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> V3dtoXdatasetOutputs:
    """
    3dtoXdataset
    
    Convert input datasets to the format needed for 3dClustSimX.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for the output file.
        mask: Mask dataset file.
        input_files: Input datasets to be converted.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dtoXdatasetOutputs`).
    """
    params = v_3dto_xdataset_params(
        prefix=prefix,
        mask=mask,
        input_files=input_files,
    )
    return v_3dto_xdataset_execute(params, runner)


__all__ = [
    "V3dtoXdatasetOutputs",
    "V_3DTO_XDATASET_METADATA",
    "v_3dto_xdataset",
    "v_3dto_xdataset_execute",
    "v_3dto_xdataset_params",
]
