# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_3DVOLREG_METADATA = Metadata(
    id="6a91f264e1e34e3d73c66cff9c688faa39d2b0de.boutiques",
    name="3dvolreg",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V3dvolregParameters = typing.TypedDict('V3dvolregParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/3dvolreg"]],
    "copyorigin": bool,
    "twopass": bool,
    "Fourier": bool,
    "in_weight_volume": typing.NotRequired[list[str] | None],
    "in_weight_volume_2": typing.NotRequired[InputPathType | None],
    "interp": typing.NotRequired[typing.Literal["fourier", "cubic", "heptic", "quintic", "linear"] | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "timeshift": bool,
    "verbose": bool,
    "basefile": typing.NotRequired[InputPathType | None],
    "zpad": typing.NotRequired[int | None],
    "prefix": str,
    "Maxdisp1d": typing.NotRequired[str | None],
    "in_file": InputPathType,
})
V3dvolregParametersTagged = typing.TypedDict('V3dvolregParametersTagged', {
    "@type": typing.Literal["afni/3dvolreg"],
    "copyorigin": bool,
    "twopass": bool,
    "Fourier": bool,
    "in_weight_volume": typing.NotRequired[list[str] | None],
    "in_weight_volume_2": typing.NotRequired[InputPathType | None],
    "interp": typing.NotRequired[typing.Literal["fourier", "cubic", "heptic", "quintic", "linear"] | None],
    "num_threads": typing.NotRequired[int | None],
    "outputtype": typing.NotRequired[typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None],
    "timeshift": bool,
    "verbose": bool,
    "basefile": typing.NotRequired[InputPathType | None],
    "zpad": typing.NotRequired[int | None],
    "prefix": str,
    "Maxdisp1d": typing.NotRequired[str | None],
    "in_file": InputPathType,
})


class V3dvolregOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V3dvolregParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    md1d_file: OutputPathType
    """Max displacement output file."""
    oned_file: OutputPathType
    """1d movement parameters output file."""
    oned_matrix_save: OutputPathType
    """Save the matrix transformation."""
    md1d_file_: OutputPathType
    """Max displacement info file."""
    oned_file_: OutputPathType
    """Movement parameters info file."""
    oned_matrix_save_: OutputPathType
    """Matrix transformation from base to input."""
    out_file: OutputPathType
    """Registered file."""


def v_3dvolreg_params(
    prefix: str,
    in_file: InputPathType,
    copyorigin: bool = False,
    twopass: bool = False,
    fourier: bool = False,
    in_weight_volume: list[str] | None = None,
    in_weight_volume_2: InputPathType | None = None,
    interp: typing.Literal["fourier", "cubic", "heptic", "quintic", "linear"] | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    timeshift: bool = False,
    verbose: bool = False,
    basefile: InputPathType | None = None,
    zpad: int | None = None,
    maxdisp1d: str | None = None,
) -> V3dvolregParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix.
        in_file: Input file to 3dvolreg.
        copyorigin: Copy base file origin coords to output.
        twopass: Do two passes of the registration algorithm.
        fourier: Perform the alignments using Fourier interpolation.
        in_weight_volume: (file or string, an integer) or file or string.\
            Weights for each voxel specified by a file with an optional volume\
            number (defaults to 0).
        in_weight_volume_2: (file or string, an integer) or file or string.\
            Weights for each voxel specified by a file with an optional volume\
            number (defaults to 0).
        interp: 'fourier' or 'cubic' or 'heptic' or 'quintic' or 'linear'.\
            Spatial interpolation methods [default = heptic].
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        timeshift: Time shift to mean slice time offset.
        verbose: More detailed description of the process.
        basefile: Base file for registration.
        zpad: Zeropad around the edges by 'n' voxels during rotations.
        maxdisp1d: Do '-maxdisp' and also write the max displacement for each\
            sub-brick into file 'mm' in 1D (columnar) format.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/3dvolreg",
        "copyorigin": copyorigin,
        "twopass": twopass,
        "Fourier": fourier,
        "timeshift": timeshift,
        "verbose": verbose,
        "prefix": prefix,
        "in_file": in_file,
    }
    if in_weight_volume is not None:
        params["in_weight_volume"] = in_weight_volume
    if in_weight_volume_2 is not None:
        params["in_weight_volume_2"] = in_weight_volume_2
    if interp is not None:
        params["interp"] = interp
    if num_threads is not None:
        params["num_threads"] = num_threads
    if outputtype is not None:
        params["outputtype"] = outputtype
    if basefile is not None:
        params["basefile"] = basefile
    if zpad is not None:
        params["zpad"] = zpad
    if maxdisp1d is not None:
        params["Maxdisp1d"] = maxdisp1d
    return params


def v_3dvolreg_cargs(
    params: V3dvolregParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("3dvolreg")
    if params.get("copyorigin", False):
        cargs.append("-twodup")
    if params.get("twopass", False):
        cargs.append("-twopass")
    if params.get("Fourier", False):
        cargs.append("-Fourier")
    if params.get("in_weight_volume", None) is not None:
        cargs.extend([
            "-weight '",
            *params.get("in_weight_volume", None)
        ])
    if params.get("in_weight_volume_2", None) is not None:
        cargs.extend([
            "-weight '",
            execution.input_file(params.get("in_weight_volume_2", None))
        ])
    if params.get("interp", None) is not None:
        cargs.extend([
            "-",
            params.get("interp", None)
        ])
    if params.get("num_threads", None) is not None:
        cargs.append(str(params.get("num_threads", None)))
    if params.get("outputtype", None) is not None:
        cargs.append(params.get("outputtype", None))
    if params.get("timeshift", False):
        cargs.append("-tshift 0")
    if params.get("verbose", False):
        cargs.append("-verbose")
    if params.get("basefile", None) is not None:
        cargs.extend([
            "-base",
            execution.input_file(params.get("basefile", None))
        ])
    if params.get("zpad", None) is not None:
        cargs.extend([
            "-zpad",
            str(params.get("zpad", None))
        ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("Maxdisp1d", None) is not None:
        cargs.extend([
            "-maxdisp1d",
            params.get("Maxdisp1d", None)
        ])
    cargs.append(execution.input_file(params.get("in_file", None)))
    return cargs


def v_3dvolreg_outputs(
    params: V3dvolregParameters,
    execution: Execution,
) -> V3dvolregOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V3dvolregOutputs(
        root=execution.output_file("."),
        md1d_file=execution.output_file(params.get("prefix", None) + "_md.1D"),
        oned_file=execution.output_file(params.get("prefix", None) + ".1D"),
        oned_matrix_save=execution.output_file(params.get("prefix", None) + ".aff12.1D"),
        md1d_file_=execution.output_file("md1d_file"),
        oned_file_=execution.output_file("oned_file"),
        oned_matrix_save_=execution.output_file("oned_matrix_save"),
        out_file=execution.output_file(params.get("prefix", None)),
    )
    return ret


def v_3dvolreg_execute(
    params: V3dvolregParameters,
    runner: Runner | None = None,
) -> V3dvolregOutputs:
    """
    3dvolreg
    
    Register input volumes to a base volume using AFNI 3dvolreg command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dvolregOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_3DVOLREG_METADATA)
    params = execution.params(params)
    cargs = v_3dvolreg_cargs(params, execution)
    ret = v_3dvolreg_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_3dvolreg(
    prefix: str,
    in_file: InputPathType,
    copyorigin: bool = False,
    twopass: bool = False,
    fourier: bool = False,
    in_weight_volume: list[str] | None = None,
    in_weight_volume_2: InputPathType | None = None,
    interp: typing.Literal["fourier", "cubic", "heptic", "quintic", "linear"] | None = None,
    num_threads: int | None = None,
    outputtype: typing.Literal["NIFTI", "AFNI", "NIFTI_GZ"] | None = None,
    timeshift: bool = False,
    verbose: bool = False,
    basefile: InputPathType | None = None,
    zpad: int | None = None,
    maxdisp1d: str | None = None,
    runner: Runner | None = None,
) -> V3dvolregOutputs:
    """
    3dvolreg
    
    Register input volumes to a base volume using AFNI 3dvolreg command.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix.
        in_file: Input file to 3dvolreg.
        copyorigin: Copy base file origin coords to output.
        twopass: Do two passes of the registration algorithm.
        fourier: Perform the alignments using Fourier interpolation.
        in_weight_volume: (file or string, an integer) or file or string.\
            Weights for each voxel specified by a file with an optional volume\
            number (defaults to 0).
        in_weight_volume_2: (file or string, an integer) or file or string.\
            Weights for each voxel specified by a file with an optional volume\
            number (defaults to 0).
        interp: 'fourier' or 'cubic' or 'heptic' or 'quintic' or 'linear'.\
            Spatial interpolation methods [default = heptic].
        num_threads: Set number of threads.
        outputtype: 'nifti' or 'afni' or 'nifti_gz'. Afni output filetype.
        timeshift: Time shift to mean slice time offset.
        verbose: More detailed description of the process.
        basefile: Base file for registration.
        zpad: Zeropad around the edges by 'n' voxels during rotations.
        maxdisp1d: Do '-maxdisp' and also write the max displacement for each\
            sub-brick into file 'mm' in 1D (columnar) format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V3dvolregOutputs`).
    """
    params = v_3dvolreg_params(
        copyorigin=copyorigin,
        twopass=twopass,
        fourier=fourier,
        in_weight_volume=in_weight_volume,
        in_weight_volume_2=in_weight_volume_2,
        interp=interp,
        num_threads=num_threads,
        outputtype=outputtype,
        timeshift=timeshift,
        verbose=verbose,
        basefile=basefile,
        zpad=zpad,
        prefix=prefix,
        maxdisp1d=maxdisp1d,
        in_file=in_file,
    )
    return v_3dvolreg_execute(params, runner)


__all__ = [
    "V3dvolregOutputs",
    "V_3DVOLREG_METADATA",
    "v_3dvolreg",
    "v_3dvolreg_execute",
    "v_3dvolreg_params",
]
