# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V_4SWAP_METADATA = Metadata(
    id="722d60c043acc3fcd3bc12bb469248826f8c2128.boutiques",
    name="4swap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V4swapParameters = typing.TypedDict('V4swapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/4swap"]],
    "files": list[InputPathType],
    "quiet": bool,
})
V4swapParametersTagged = typing.TypedDict('V4swapParametersTagged', {
    "@type": typing.Literal["afni/4swap"],
    "files": list[InputPathType],
    "quiet": bool,
})


class V4swapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V4swapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v_4swap_params(
    files: list[InputPathType],
    quiet: bool = False,
) -> V4swapParametersTagged:
    """
    Build parameters.
    
    Args:
        files: List of files to process.
        quiet: Work quietly; suppress output messages.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/4swap",
        "files": files,
        "quiet": quiet,
    }
    return params


def v_4swap_cargs(
    params: V4swapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("4swap")
    cargs.extend([execution.input_file(f) for f in params.get("files", None)])
    if params.get("quiet", False):
        cargs.append("-q")
    return cargs


def v_4swap_outputs(
    params: V4swapParameters,
    execution: Execution,
) -> V4swapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V4swapOutputs(
        root=execution.output_file("."),
    )
    return ret


def v_4swap_execute(
    params: V4swapParameters,
    runner: Runner | None = None,
) -> V4swapOutputs:
    """
    4swap
    
    Swaps byte quadruples on the listed files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V4swapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V_4SWAP_METADATA)
    params = execution.params(params)
    cargs = v_4swap_cargs(params, execution)
    ret = v_4swap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v_4swap(
    files: list[InputPathType],
    quiet: bool = False,
    runner: Runner | None = None,
) -> V4swapOutputs:
    """
    4swap
    
    Swaps byte quadruples on the listed files.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        files: List of files to process.
        quiet: Work quietly; suppress output messages.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V4swapOutputs`).
    """
    params = v_4swap_params(
        files=files,
        quiet=quiet,
    )
    return v_4swap_execute(params, runner)


__all__ = [
    "V4swapOutputs",
    "V_4SWAP_METADATA",
    "v_4swap",
    "v_4swap_execute",
    "v_4swap_params",
]
