# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__1D_DIFF_MAG_METADATA = Metadata(
    id="79a9dcf4877ee3724d0c39add1bc50f6b62d7601.boutiques",
    name="@1dDiffMag",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V1dDiffMagParameters = typing.TypedDict('V1dDiffMagParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@1dDiffMag"]],
    "infile": InputPathType,
})
V1dDiffMagParametersTagged = typing.TypedDict('V1dDiffMagParametersTagged', {
    "@type": typing.Literal["afni/@1dDiffMag"],
    "infile": InputPathType,
})


class V1dDiffMagOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V1dDiffMagParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    result_stdout: OutputPathType
    """The result as a single number displayed on stdout"""


def v__1d_diff_mag_params(
    infile: InputPathType,
) -> V1dDiffMagParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: 1D input file to compute the magnitude estimate of the first\
            differences.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@1dDiffMag",
        "infile": infile,
    }
    return params


def v__1d_diff_mag_cargs(
    params: V1dDiffMagParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@1dDiffMag")
    cargs.append(execution.input_file(params.get("infile", None)))
    return cargs


def v__1d_diff_mag_outputs(
    params: V1dDiffMagParameters,
    execution: Execution,
) -> V1dDiffMagOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V1dDiffMagOutputs(
        root=execution.output_file("."),
        result_stdout=execution.output_file("stdout"),
    )
    return ret


def v__1d_diff_mag_execute(
    params: V1dDiffMagParameters,
    runner: Runner | None = None,
) -> V1dDiffMagOutputs:
    """
    @1dDiffMag
    
    Computes a magnitude estimate of the first differences of a 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dDiffMagOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__1D_DIFF_MAG_METADATA)
    params = execution.params(params)
    cargs = v__1d_diff_mag_cargs(params, execution)
    ret = v__1d_diff_mag_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__1d_diff_mag(
    infile: InputPathType,
    runner: Runner | None = None,
) -> V1dDiffMagOutputs:
    """
    @1dDiffMag
    
    Computes a magnitude estimate of the first differences of a 1D file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: 1D input file to compute the magnitude estimate of the first\
            differences.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V1dDiffMagOutputs`).
    """
    params = v__1d_diff_mag_params(
        infile=infile,
    )
    return v__1d_diff_mag_execute(params, runner)


__all__ = [
    "V1dDiffMagOutputs",
    "V__1D_DIFF_MAG_METADATA",
    "v__1d_diff_mag",
    "v__1d_diff_mag_execute",
    "v__1d_diff_mag_params",
]
