# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__2DWARPER_METADATA = Metadata(
    id="a639e33d0f62eeb0f9bae0c30caea70084cc4a6e.boutiques",
    name="@2dwarper",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V2dwarperParameters = typing.TypedDict('V2dwarperParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@2dwarper"]],
    "input_dataset": InputPathType,
})
V2dwarperParametersTagged = typing.TypedDict('V2dwarperParametersTagged', {
    "@type": typing.Literal["afni/@2dwarper"],
    "input_dataset": InputPathType,
})


class V2dwarperOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V2dwarperParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Warped output image from the dataset"""


def v__2dwarper_params(
    input_dataset: InputPathType,
) -> V2dwarperParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset (e.g., image to be warped).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@2dwarper",
        "input_dataset": input_dataset,
    }
    return params


def v__2dwarper_cargs(
    params: V2dwarperParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@2dwarper")
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    return cargs


def v__2dwarper_outputs(
    params: V2dwarperParameters,
    execution: Execution,
) -> V2dwarperOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V2dwarperOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file("warped_output"),
    )
    return ret


def v__2dwarper_execute(
    params: V2dwarperParameters,
    runner: Runner | None = None,
) -> V2dwarperOutputs:
    """
    @2dwarper
    
    2D image warping tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dwarperOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__2DWARPER_METADATA)
    params = execution.params(params)
    cargs = v__2dwarper_cargs(params, execution)
    ret = v__2dwarper_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__2dwarper(
    input_dataset: InputPathType,
    runner: Runner | None = None,
) -> V2dwarperOutputs:
    """
    @2dwarper
    
    2D image warping tool.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset (e.g., image to be warped).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dwarperOutputs`).
    """
    params = v__2dwarper_params(
        input_dataset=input_dataset,
    )
    return v__2dwarper_execute(params, runner)


__all__ = [
    "V2dwarperOutputs",
    "V__2DWARPER_METADATA",
    "v__2dwarper",
    "v__2dwarper_execute",
    "v__2dwarper_params",
]
