# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__2DWARPER_ALLIN_METADATA = Metadata(
    id="225a74d08261c6d90001aa24a11526d518df01f8.boutiques",
    name="@2dwarper.Allin",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V2dwarperAllinParameters = typing.TypedDict('V2dwarperAllinParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@2dwarper.Allin"]],
    "input_prefix": str,
    "mask_prefix": typing.NotRequired[str | None],
    "output_prefix": typing.NotRequired[str | None],
})
V2dwarperAllinParametersTagged = typing.TypedDict('V2dwarperAllinParametersTagged', {
    "@type": typing.Literal["afni/@2dwarper.Allin"],
    "input_prefix": str,
    "mask_prefix": typing.NotRequired[str | None],
    "output_prefix": typing.NotRequired[str | None],
})


class V2dwarperAllinOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V2dwarperAllinParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    reg_output: OutputPathType | None
    """Output registered dataset"""
    param_files: OutputPathType | None
    """Output registration parameter files"""


def v__2dwarper_allin_params(
    input_prefix: str,
    mask_prefix: str | None = None,
    output_prefix: str | None = None,
) -> V2dwarperAllinParametersTagged:
    """
    Build parameters.
    
    Args:
        input_prefix: Prefix for the input 3D+time dataset.
        mask_prefix: Prefix of an existing mask dataset.
        output_prefix: Prefix for output datasets.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@2dwarper.Allin",
        "input_prefix": input_prefix,
    }
    if mask_prefix is not None:
        params["mask_prefix"] = mask_prefix
    if output_prefix is not None:
        params["output_prefix"] = output_prefix
    return params


def v__2dwarper_allin_cargs(
    params: V2dwarperAllinParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@2dwarper.Allin")
    cargs.append(params.get("input_prefix", None))
    if params.get("mask_prefix", None) is not None:
        cargs.extend([
            "-mask",
            params.get("mask_prefix", None)
        ])
    if params.get("output_prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("output_prefix", None)
        ])
    return cargs


def v__2dwarper_allin_outputs(
    params: V2dwarperAllinParameters,
    execution: Execution,
) -> V2dwarperAllinOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V2dwarperAllinOutputs(
        root=execution.output_file("."),
        reg_output=execution.output_file(params.get("output_prefix", None) + "_reg+orig.HEAD") if (params.get("output_prefix") is not None) else None,
        param_files=execution.output_file(params.get("output_prefix", None) + "_param.1D") if (params.get("output_prefix") is not None) else None,
    )
    return ret


def v__2dwarper_allin_execute(
    params: V2dwarperAllinParameters,
    runner: Runner | None = None,
) -> V2dwarperAllinOutputs:
    """
    @2dwarper.Allin
    
    Perform 2D registration on each slice of a 3D+time dataset, and combine the
    results.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dwarperAllinOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__2DWARPER_ALLIN_METADATA)
    params = execution.params(params)
    cargs = v__2dwarper_allin_cargs(params, execution)
    ret = v__2dwarper_allin_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__2dwarper_allin(
    input_prefix: str,
    mask_prefix: str | None = None,
    output_prefix: str | None = None,
    runner: Runner | None = None,
) -> V2dwarperAllinOutputs:
    """
    @2dwarper.Allin
    
    Perform 2D registration on each slice of a 3D+time dataset, and combine the
    results.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_prefix: Prefix for the input 3D+time dataset.
        mask_prefix: Prefix of an existing mask dataset.
        output_prefix: Prefix for output datasets.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V2dwarperAllinOutputs`).
    """
    params = v__2dwarper_allin_params(
        input_prefix=input_prefix,
        mask_prefix=mask_prefix,
        output_prefix=output_prefix,
    )
    return v__2dwarper_allin_execute(params, runner)


__all__ = [
    "V2dwarperAllinOutputs",
    "V__2DWARPER_ALLIN_METADATA",
    "v__2dwarper_allin",
    "v__2dwarper_allin_execute",
    "v__2dwarper_allin_params",
]
