# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__4_DAVERAGE_METADATA = Metadata(
    id="cfb332d0717a18e6198e0993e02a43b342500a1f.boutiques",
    name="@4Daverage",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


V4DaverageParameters = typing.TypedDict('V4DaverageParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@4Daverage"]],
    "output_prefix": str,
    "input_files": list[InputPathType],
})
V4DaverageParametersTagged = typing.TypedDict('V4DaverageParametersTagged', {
    "@type": typing.Literal["afni/@4Daverage"],
    "output_prefix": str,
    "input_files": list[InputPathType],
})


class V4DaverageOutputs(typing.NamedTuple):
    """
    Output object returned when calling `V4DaverageParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__4_daverage_params(
    output_prefix: str,
    input_files: list[InputPathType],
) -> V4DaverageParametersTagged:
    """
    Build parameters.
    
    Args:
        output_prefix: Prefix for the output 3D+t brick.
        input_files: List of 3D+t brick filenames to be averaged (e.g.,\
            brick1+orig, brick2+orig). Can use wildcards.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@4Daverage",
        "output_prefix": output_prefix,
        "input_files": input_files,
    }
    return params


def v__4_daverage_cargs(
    params: V4DaverageParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@4Daverage")
    cargs.append(params.get("output_prefix", None))
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def v__4_daverage_outputs(
    params: V4DaverageParameters,
    execution: Execution,
) -> V4DaverageOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = V4DaverageOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__4_daverage_execute(
    params: V4DaverageParameters,
    runner: Runner | None = None,
) -> V4DaverageOutputs:
    """
    @4Daverage
    
    Script for computing average 3D+time bricks using 3Dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V4DaverageOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__4_DAVERAGE_METADATA)
    params = execution.params(params)
    cargs = v__4_daverage_cargs(params, execution)
    ret = v__4_daverage_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__4_daverage(
    output_prefix: str,
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> V4DaverageOutputs:
    """
    @4Daverage
    
    Script for computing average 3D+time bricks using 3Dcalc.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        output_prefix: Prefix for the output 3D+t brick.
        input_files: List of 3D+t brick filenames to be averaged (e.g.,\
            brick1+orig, brick2+orig). Can use wildcards.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `V4DaverageOutputs`).
    """
    params = v__4_daverage_params(
        output_prefix=output_prefix,
        input_files=input_files,
    )
    return v__4_daverage_execute(params, runner)


__all__ = [
    "V4DaverageOutputs",
    "V__4_DAVERAGE_METADATA",
    "v__4_daverage",
    "v__4_daverage_execute",
    "v__4_daverage_params",
]
