# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__AFNI_ENV_METADATA = Metadata(
    id="94c9a0b39d409448fae9a4947b634d3afd5edb15.boutiques",
    name="@AfniEnv",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAfniEnvParameters = typing.TypedDict('VAfniEnvParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@AfniEnv"]],
    "set_flag": typing.NotRequired[list[str] | None],
    "unset_flag": typing.NotRequired[str | None],
    "get_flag": typing.NotRequired[str | None],
    "help_flag": bool,
    "help_web_flag": bool,
    "help_web_flag_alias": bool,
    "help_view_flag": bool,
    "help_view_flag_alias": bool,
    "all_opts_flag": bool,
    "help_find_flag": typing.NotRequired[str | None],
})
VAfniEnvParametersTagged = typing.TypedDict('VAfniEnvParametersTagged', {
    "@type": typing.Literal["afni/@AfniEnv"],
    "set_flag": typing.NotRequired[list[str] | None],
    "unset_flag": typing.NotRequired[str | None],
    "get_flag": typing.NotRequired[str | None],
    "help_flag": bool,
    "help_web_flag": bool,
    "help_web_flag_alias": bool,
    "help_view_flag": bool,
    "help_view_flag_alias": bool,
    "all_opts_flag": bool,
    "help_find_flag": typing.NotRequired[str | None],
})


class VAfniEnvOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VAfniEnvParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__afni_env_params(
    set_flag: list[str] | None = None,
    unset_flag: str | None = None,
    get_flag: str | None = None,
    help_flag: bool = False,
    help_web_flag: bool = False,
    help_web_flag_alias: bool = False,
    help_view_flag: bool = False,
    help_view_flag_alias: bool = False,
    all_opts_flag: bool = False,
    help_find_flag: str | None = None,
) -> VAfniEnvParametersTagged:
    """
    Build parameters.
    
    Args:
        set_flag: Set environment variable NAME to value VALUE.
        unset_flag: Unset environment variable NAME.
        get_flag: Get the value of environment variable NAME.
        help_flag: Display the help message for @AfniEnv script.
        help_web_flag: Open webpage with help for this program.
        help_web_flag_alias: Same as -h_web.
        help_view_flag: Open -help output in a GUI editor.
        help_view_flag_alias: Same as -h_view.
        all_opts_flag: List all of the options for this script.
        help_find_flag: Search for lines containing WORD in -help output.\
            Search is approximate.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@AfniEnv",
        "help_flag": help_flag,
        "help_web_flag": help_web_flag,
        "help_web_flag_alias": help_web_flag_alias,
        "help_view_flag": help_view_flag,
        "help_view_flag_alias": help_view_flag_alias,
        "all_opts_flag": all_opts_flag,
    }
    if set_flag is not None:
        params["set_flag"] = set_flag
    if unset_flag is not None:
        params["unset_flag"] = unset_flag
    if get_flag is not None:
        params["get_flag"] = get_flag
    if help_find_flag is not None:
        params["help_find_flag"] = help_find_flag
    return params


def v__afni_env_cargs(
    params: VAfniEnvParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@AfniEnv")
    if params.get("set_flag", None) is not None:
        cargs.extend([
            "-set",
            *params.get("set_flag", None)
        ])
    if params.get("unset_flag", None) is not None:
        cargs.extend([
            "-unset",
            params.get("unset_flag", None)
        ])
    if params.get("get_flag", None) is not None:
        cargs.extend([
            "-get",
            params.get("get_flag", None)
        ])
    if params.get("help_flag", False):
        cargs.append("-help")
    if params.get("help_web_flag", False):
        cargs.append("-h_web")
    if params.get("help_web_flag_alias", False):
        cargs.append("-hweb")
    if params.get("help_view_flag", False):
        cargs.append("-h_view")
    if params.get("help_view_flag_alias", False):
        cargs.append("-hview")
    if params.get("all_opts_flag", False):
        cargs.append("-all_opts")
    if params.get("help_find_flag", None) is not None:
        cargs.extend([
            "-h_find",
            params.get("help_find_flag", None)
        ])
    return cargs


def v__afni_env_outputs(
    params: VAfniEnvParameters,
    execution: Execution,
) -> VAfniEnvOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAfniEnvOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__afni_env_execute(
    params: VAfniEnvParameters,
    runner: Runner | None = None,
) -> VAfniEnvOutputs:
    """
    @AfniEnv
    
    Script to set or unset an AFNI environment variable in your .afnirc file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniEnvOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__AFNI_ENV_METADATA)
    params = execution.params(params)
    cargs = v__afni_env_cargs(params, execution)
    ret = v__afni_env_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__afni_env(
    set_flag: list[str] | None = None,
    unset_flag: str | None = None,
    get_flag: str | None = None,
    help_flag: bool = False,
    help_web_flag: bool = False,
    help_web_flag_alias: bool = False,
    help_view_flag: bool = False,
    help_view_flag_alias: bool = False,
    all_opts_flag: bool = False,
    help_find_flag: str | None = None,
    runner: Runner | None = None,
) -> VAfniEnvOutputs:
    """
    @AfniEnv
    
    Script to set or unset an AFNI environment variable in your .afnirc file.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        set_flag: Set environment variable NAME to value VALUE.
        unset_flag: Unset environment variable NAME.
        get_flag: Get the value of environment variable NAME.
        help_flag: Display the help message for @AfniEnv script.
        help_web_flag: Open webpage with help for this program.
        help_web_flag_alias: Same as -h_web.
        help_view_flag: Open -help output in a GUI editor.
        help_view_flag_alias: Same as -h_view.
        all_opts_flag: List all of the options for this script.
        help_find_flag: Search for lines containing WORD in -help output.\
            Search is approximate.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniEnvOutputs`).
    """
    params = v__afni_env_params(
        set_flag=set_flag,
        unset_flag=unset_flag,
        get_flag=get_flag,
        help_flag=help_flag,
        help_web_flag=help_web_flag,
        help_web_flag_alias=help_web_flag_alias,
        help_view_flag=help_view_flag,
        help_view_flag_alias=help_view_flag_alias,
        all_opts_flag=all_opts_flag,
        help_find_flag=help_find_flag,
    )
    return v__afni_env_execute(params, runner)


__all__ = [
    "VAfniEnvOutputs",
    "V__AFNI_ENV_METADATA",
    "v__afni_env",
    "v__afni_env_execute",
    "v__afni_env_params",
]
