# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__AFNI_ORIENT2_RAIMAP_METADATA = Metadata(
    id="febf1cf266ecd5b8f67d7b9d8795b382c26c3672.boutiques",
    name="@AfniOrient2RAImap",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAfniOrient2RaimapParameters = typing.TypedDict('VAfniOrient2RaimapParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@AfniOrient2RAImap"]],
    "orientation_code": str,
})
VAfniOrient2RaimapParametersTagged = typing.TypedDict('VAfniOrient2RaimapParametersTagged', {
    "@type": typing.Literal["afni/@AfniOrient2RAImap"],
    "orientation_code": str,
})


class VAfniOrient2RaimapOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VAfniOrient2RaimapParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__afni_orient2_raimap_params(
    orientation_code: str,
) -> VAfniOrient2RaimapParametersTagged:
    """
    Build parameters.
    
    Args:
        orientation_code: Orientation code (e.g., RAI, LSP).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@AfniOrient2RAImap",
        "orientation_code": orientation_code,
    }
    return params


def v__afni_orient2_raimap_cargs(
    params: VAfniOrient2RaimapParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@AfniOrient2RAImap")
    cargs.append(params.get("orientation_code", None))
    return cargs


def v__afni_orient2_raimap_outputs(
    params: VAfniOrient2RaimapParameters,
    execution: Execution,
) -> VAfniOrient2RaimapOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAfniOrient2RaimapOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__afni_orient2_raimap_execute(
    params: VAfniOrient2RaimapParameters,
    runner: Runner | None = None,
) -> VAfniOrient2RaimapOutputs:
    """
    @AfniOrient2RAImap
    
    Returns the index map for the RAI directions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniOrient2RaimapOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__AFNI_ORIENT2_RAIMAP_METADATA)
    params = execution.params(params)
    cargs = v__afni_orient2_raimap_cargs(params, execution)
    ret = v__afni_orient2_raimap_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__afni_orient2_raimap(
    orientation_code: str,
    runner: Runner | None = None,
) -> VAfniOrient2RaimapOutputs:
    """
    @AfniOrient2RAImap
    
    Returns the index map for the RAI directions.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        orientation_code: Orientation code (e.g., RAI, LSP).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniOrient2RaimapOutputs`).
    """
    params = v__afni_orient2_raimap_params(
        orientation_code=orientation_code,
    )
    return v__afni_orient2_raimap_execute(params, runner)


__all__ = [
    "VAfniOrient2RaimapOutputs",
    "V__AFNI_ORIENT2_RAIMAP_METADATA",
    "v__afni_orient2_raimap",
    "v__afni_orient2_raimap_execute",
    "v__afni_orient2_raimap_params",
]
