# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__AFNI_REFACER_MAKE_ONEBIG_A12_METADATA = Metadata(
    id="0bc73fd2469df279796b8de9f4bc8643932c82f1.boutiques",
    name="@afni_refacer_make_onebigA12",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAfniRefacerMakeOnebigA12Parameters = typing.TypedDict('VAfniRefacerMakeOnebigA12Parameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@afni_refacer_make_onebigA12"]],
    "t1w_dataset": InputPathType,
})
VAfniRefacerMakeOnebigA12ParametersTagged = typing.TypedDict('VAfniRefacerMakeOnebigA12ParametersTagged', {
    "@type": typing.Literal["afni/@afni_refacer_make_onebigA12"],
    "t1w_dataset": InputPathType,
})


class VAfniRefacerMakeOnebigA12Outputs(typing.NamedTuple):
    """
    Output object returned when calling `VAfniRefacerMakeOnebigA12Parameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    aligned_output: OutputPathType
    """Aligned T1w dataset to MNI template with expanded 'big' grid"""


def v__afni_refacer_make_onebig_a12_params(
    t1w_dataset: InputPathType,
) -> VAfniRefacerMakeOnebigA12ParametersTagged:
    """
    Build parameters.
    
    Args:
        t1w_dataset: Input T1w dataset name.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@afni_refacer_make_onebigA12",
        "t1w_dataset": t1w_dataset,
    }
    return params


def v__afni_refacer_make_onebig_a12_cargs(
    params: VAfniRefacerMakeOnebigA12Parameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@afni_refacer_make_onebigA12")
    cargs.append(execution.input_file(params.get("t1w_dataset", None)))
    return cargs


def v__afni_refacer_make_onebig_a12_outputs(
    params: VAfniRefacerMakeOnebigA12Parameters,
    execution: Execution,
) -> VAfniRefacerMakeOnebigA12Outputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAfniRefacerMakeOnebigA12Outputs(
        root=execution.output_file("."),
        aligned_output=execution.output_file(pathlib.Path(params.get("t1w_dataset", None)).name + "_aligned_to_MNI.nii.gz"),
    )
    return ret


def v__afni_refacer_make_onebig_a12_execute(
    params: VAfniRefacerMakeOnebigA12Parameters,
    runner: Runner | None = None,
) -> VAfniRefacerMakeOnebigA12Outputs:
    """
    @afni_refacer_make_onebigA12
    
    Script to align a single T1w dataset to the MNI template and expand it to a
    'big' grid.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniRefacerMakeOnebigA12Outputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__AFNI_REFACER_MAKE_ONEBIG_A12_METADATA)
    params = execution.params(params)
    cargs = v__afni_refacer_make_onebig_a12_cargs(params, execution)
    ret = v__afni_refacer_make_onebig_a12_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__afni_refacer_make_onebig_a12(
    t1w_dataset: InputPathType,
    runner: Runner | None = None,
) -> VAfniRefacerMakeOnebigA12Outputs:
    """
    @afni_refacer_make_onebigA12
    
    Script to align a single T1w dataset to the MNI template and expand it to a
    'big' grid.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        t1w_dataset: Input T1w dataset name.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAfniRefacerMakeOnebigA12Outputs`).
    """
    params = v__afni_refacer_make_onebig_a12_params(
        t1w_dataset=t1w_dataset,
    )
    return v__afni_refacer_make_onebig_a12_execute(params, runner)


__all__ = [
    "VAfniRefacerMakeOnebigA12Outputs",
    "V__AFNI_REFACER_MAKE_ONEBIG_A12_METADATA",
    "v__afni_refacer_make_onebig_a12",
    "v__afni_refacer_make_onebig_a12_execute",
    "v__afni_refacer_make_onebig_a12_params",
]
