# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__ALIGN_PARTIAL_OBLIQUE_METADATA = Metadata(
    id="848c2d43f23ed079e10b11fc04e86a8910515626.boutiques",
    name="@align_partial_oblique",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAlignPartialObliqueParameters = typing.TypedDict('VAlignPartialObliqueParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@align_partial_oblique"]],
    "base": InputPathType,
    "input": InputPathType,
    "suffix": typing.NotRequired[str | None],
    "keep_tmp": bool,
    "clean": bool,
    "dxyz": typing.NotRequired[float | None],
    "dx": typing.NotRequired[float | None],
    "dy": typing.NotRequired[float | None],
    "dz": typing.NotRequired[float | None],
})
VAlignPartialObliqueParametersTagged = typing.TypedDict('VAlignPartialObliqueParametersTagged', {
    "@type": typing.Literal["afni/@align_partial_oblique"],
    "base": InputPathType,
    "input": InputPathType,
    "suffix": typing.NotRequired[str | None],
    "keep_tmp": bool,
    "clean": bool,
    "dxyz": typing.NotRequired[float | None],
    "dx": typing.NotRequired[float | None],
    "dy": typing.NotRequired[float | None],
    "dz": typing.NotRequired[float | None],
})


class VAlignPartialObliqueOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VAlignPartialObliqueParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    aligned_output: OutputPathType
    """Aligned partial coverage T1 weighted dataset"""


def v__align_partial_oblique_params(
    base: InputPathType,
    input_: InputPathType,
    suffix: str | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
) -> VAlignPartialObliqueParametersTagged:
    """
    Build parameters.
    
    Args:
        base: Reference anatomical full coverage volume.
        input_: Partial coverage T1 weighted non-oblique dataset.
        suffix: Output dataset name is formed by adding SUF to the prefix of\
            the base dataset. The default suffix is _alnd_PartialCoverageObliqueT1.
        keep_tmp: Keep temporary files.
        clean: Clean all temp files, likely left from -keep_tmp option then\
            exit.
        dxyz: Cubic voxel size of output dataset in TLRC space Default MM is 1.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@align_partial_oblique",
        "base": base,
        "input": input_,
        "keep_tmp": keep_tmp,
        "clean": clean,
    }
    if suffix is not None:
        params["suffix"] = suffix
    if dxyz is not None:
        params["dxyz"] = dxyz
    if dx is not None:
        params["dx"] = dx
    if dy is not None:
        params["dy"] = dy
    if dz is not None:
        params["dz"] = dz
    return params


def v__align_partial_oblique_cargs(
    params: VAlignPartialObliqueParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@align_partial_oblique")
    cargs.extend([
        "-base",
        execution.input_file(params.get("base", None))
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input", None))
    ])
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    if params.get("keep_tmp", False):
        cargs.append("-keep_tmp")
    if params.get("clean", False):
        cargs.append("-clean")
    if params.get("dxyz", None) is not None:
        cargs.extend([
            "-dxyz",
            str(params.get("dxyz", None))
        ])
    if params.get("dx", None) is not None:
        cargs.extend([
            "-dx",
            str(params.get("dx", None))
        ])
    if params.get("dy", None) is not None:
        cargs.extend([
            "-dy",
            str(params.get("dy", None))
        ])
    if params.get("dz", None) is not None:
        cargs.extend([
            "-dz",
            str(params.get("dz", None))
        ])
    return cargs


def v__align_partial_oblique_outputs(
    params: VAlignPartialObliqueParameters,
    execution: Execution,
) -> VAlignPartialObliqueOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAlignPartialObliqueOutputs(
        root=execution.output_file("."),
        aligned_output=execution.output_file(pathlib.Path(params.get("base", None)).name + "_alnd_" + pathlib.Path(params.get("input", None)).name + ".nii.gz"),
    )
    return ret


def v__align_partial_oblique_execute(
    params: VAlignPartialObliqueParameters,
    runner: Runner | None = None,
) -> VAlignPartialObliqueOutputs:
    """
    @align_partial_oblique
    
    A script to align a full coverage T1 weighted non-oblique dataset to match a
    partial coverage T1 weighted non-oblique dataset. Alignment is done with a
    rotation and shift (6 parameters) transform only.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAlignPartialObliqueOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__ALIGN_PARTIAL_OBLIQUE_METADATA)
    params = execution.params(params)
    cargs = v__align_partial_oblique_cargs(params, execution)
    ret = v__align_partial_oblique_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__align_partial_oblique(
    base: InputPathType,
    input_: InputPathType,
    suffix: str | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
    runner: Runner | None = None,
) -> VAlignPartialObliqueOutputs:
    """
    @align_partial_oblique
    
    A script to align a full coverage T1 weighted non-oblique dataset to match a
    partial coverage T1 weighted non-oblique dataset. Alignment is done with a
    rotation and shift (6 parameters) transform only.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        base: Reference anatomical full coverage volume.
        input_: Partial coverage T1 weighted non-oblique dataset.
        suffix: Output dataset name is formed by adding SUF to the prefix of\
            the base dataset. The default suffix is _alnd_PartialCoverageObliqueT1.
        keep_tmp: Keep temporary files.
        clean: Clean all temp files, likely left from -keep_tmp option then\
            exit.
        dxyz: Cubic voxel size of output dataset in TLRC space Default MM is 1.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAlignPartialObliqueOutputs`).
    """
    params = v__align_partial_oblique_params(
        base=base,
        input_=input_,
        suffix=suffix,
        keep_tmp=keep_tmp,
        clean=clean,
        dxyz=dxyz,
        dx=dx,
        dy=dy,
        dz=dz,
    )
    return v__align_partial_oblique_execute(params, runner)


__all__ = [
    "VAlignPartialObliqueOutputs",
    "V__ALIGN_PARTIAL_OBLIQUE_METADATA",
    "v__align_partial_oblique",
    "v__align_partial_oblique_execute",
    "v__align_partial_oblique_params",
]
