# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__ANIMAL_WARPER_METADATA = Metadata(
    id="0c1bdd2a3404fa7897ef96606ac79c836123d8fe.boutiques",
    name="@animal_warper",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAnimalWarperParameters = typing.TypedDict('VAnimalWarperParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@animal_warper"]],
    "input_file": InputPathType,
    "base_template": InputPathType,
    "output_dir": str,
    "brainmask": typing.NotRequired[InputPathType | None],
    "atlases": typing.NotRequired[list[InputPathType] | None],
    "atlas_followers": typing.NotRequired[list[InputPathType] | None],
    "seg_followers": typing.NotRequired[list[InputPathType] | None],
    "template_followers": typing.NotRequired[list[InputPathType] | None],
    "dset_followers": typing.NotRequired[list[InputPathType] | None],
    "roidset_followers": typing.NotRequired[list[InputPathType] | None],
    "input_abbrev": typing.NotRequired[str | None],
    "base_abbrev": typing.NotRequired[str | None],
    "atlas_abbrevs": typing.NotRequired[list[str] | None],
    "template_abbrevs": typing.NotRequired[list[str] | None],
    "seg_abbrevs": typing.NotRequired[list[str] | None],
    "dset_abbrevs": typing.NotRequired[list[str] | None],
    "roidset_abbrevs": typing.NotRequired[list[str] | None],
    "align_centers_meth": typing.NotRequired[str | None],
    "aff_move_opt": typing.NotRequired[str | None],
    "cost": typing.NotRequired[str | None],
    "maxlev": typing.NotRequired[float | None],
    "no_surfaces": bool,
    "feature_size": typing.NotRequired[float | None],
    "supersize": bool,
    "init_scale": typing.NotRequired[float | None],
    "mode_smooth_size": typing.NotRequired[float | None],
    "mode_smooth_replacement_off": bool,
    "center_out": typing.NotRequired[str | None],
    "align_type": typing.NotRequired[str | None],
    "extra_qw_opts": typing.NotRequired[str | None],
    "keep_temp": bool,
    "version": bool,
    "ok_to_exist": bool,
    "echo": bool,
})
VAnimalWarperParametersTagged = typing.TypedDict('VAnimalWarperParametersTagged', {
    "@type": typing.Literal["afni/@animal_warper"],
    "input_file": InputPathType,
    "base_template": InputPathType,
    "output_dir": str,
    "brainmask": typing.NotRequired[InputPathType | None],
    "atlases": typing.NotRequired[list[InputPathType] | None],
    "atlas_followers": typing.NotRequired[list[InputPathType] | None],
    "seg_followers": typing.NotRequired[list[InputPathType] | None],
    "template_followers": typing.NotRequired[list[InputPathType] | None],
    "dset_followers": typing.NotRequired[list[InputPathType] | None],
    "roidset_followers": typing.NotRequired[list[InputPathType] | None],
    "input_abbrev": typing.NotRequired[str | None],
    "base_abbrev": typing.NotRequired[str | None],
    "atlas_abbrevs": typing.NotRequired[list[str] | None],
    "template_abbrevs": typing.NotRequired[list[str] | None],
    "seg_abbrevs": typing.NotRequired[list[str] | None],
    "dset_abbrevs": typing.NotRequired[list[str] | None],
    "roidset_abbrevs": typing.NotRequired[list[str] | None],
    "align_centers_meth": typing.NotRequired[str | None],
    "aff_move_opt": typing.NotRequired[str | None],
    "cost": typing.NotRequired[str | None],
    "maxlev": typing.NotRequired[float | None],
    "no_surfaces": bool,
    "feature_size": typing.NotRequired[float | None],
    "supersize": bool,
    "init_scale": typing.NotRequired[float | None],
    "mode_smooth_size": typing.NotRequired[float | None],
    "mode_smooth_replacement_off": bool,
    "center_out": typing.NotRequired[str | None],
    "align_type": typing.NotRequired[str | None],
    "extra_qw_opts": typing.NotRequired[str | None],
    "keep_temp": bool,
    "version": bool,
    "ok_to_exist": bool,
    "echo": bool,
})


class VAnimalWarperOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VAnimalWarperParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    warp2std: OutputPathType
    """input dataset nonlinearly warped to template"""
    qc_image_initial: OutputPathType
    """initial QC image montage showing overlap of source and base dataset"""
    qc_image_initial_sh: OutputPathType
    """initial QC image montage after shifting centers of source and base
    dataset"""
    dset_followers_out: OutputPathType
    """copy(s) of -dset_followers mapped to template space"""
    roidset_followers_out: OutputPathType
    """copy(s) of -roidset_followers mapped to template space"""
    animal_outs_guide: OutputPathType
    """guide to data in output directory"""


def v__animal_warper_params(
    input_file: InputPathType,
    base_template: InputPathType,
    output_dir: str,
    brainmask: InputPathType | None = None,
    atlases: list[InputPathType] | None = None,
    atlas_followers: list[InputPathType] | None = None,
    seg_followers: list[InputPathType] | None = None,
    template_followers: list[InputPathType] | None = None,
    dset_followers: list[InputPathType] | None = None,
    roidset_followers: list[InputPathType] | None = None,
    input_abbrev: str | None = None,
    base_abbrev: str | None = None,
    atlas_abbrevs: list[str] | None = None,
    template_abbrevs: list[str] | None = None,
    seg_abbrevs: list[str] | None = None,
    dset_abbrevs: list[str] | None = None,
    roidset_abbrevs: list[str] | None = None,
    align_centers_meth: str | None = None,
    aff_move_opt: str | None = None,
    cost: str | None = None,
    maxlev: float | None = None,
    no_surfaces: bool = False,
    feature_size: float | None = None,
    supersize: bool = False,
    init_scale: float | None = None,
    mode_smooth_size: float | None = None,
    mode_smooth_replacement_off: bool = False,
    center_out: str | None = None,
    align_type: str | None = None,
    extra_qw_opts: str | None = None,
    keep_temp: bool = False,
    version: bool = False,
    ok_to_exist: bool = False,
    echo: bool = False,
) -> VAnimalWarperParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: input dataset to align to base template.
        base_template: base dataset (template) to align with.
        output_dir: output directory where all processing will be performed.
        brainmask: provide a brainmask in the base template space.
        atlases: one or more atlas datasets in the base volume space.
        atlas_followers: one or more atlas datasets in the base volume space.
        seg_followers: one or more segmentation datasets in the base volume\
            space.
        template_followers: one or more datasets in the template volume space.
        dset_followers: one or more datasets in the input volume space.
        roidset_followers: one or more (int-valued) datasets in the input\
            volume space.
        input_abbrev: specify abbreviation for input dataset.
        base_abbrev: specify abbreviation for base dataset.
        atlas_abbrevs: specify an abbreviation for each atlas follower dataset.
        template_abbrevs: specify an abbreviation for each template follower\
            dataset.
        seg_abbrevs: specify an abbreviation for each segmentation follower\
            dataset.
        dset_abbrevs: specify an abbreviation for each dataset follower dataset.
        roidset_abbrevs: specify an abbreviation for each ROI dataset follower\
            dataset.
        align_centers_meth: center alignment method to use.
        aff_move_opt: alignment movement options for affine alignment step.
        cost: cost function for affine and nonlinear alignment.
        maxlev: Max level for nonlinear warping. Final patch size is determined\
            based on this value.
        no_surfaces: Do not make surfaces for atlas regions in native space.
        feature_size: Set feature size for affine alignment (in mm).
        supersize: Allow up to 50% size difference between subject and template.
        init_scale: Approximate length ratio of input to template for initial\
            scaling.
        mode_smooth_size: Modal smoothing kernel size in voxels.
        mode_smooth_replacement_off: Turn off replacement in modal smoothing.
        center_out: Center native-space output to native original space or\
            template space center-shifted.
        align_type: Specify level of alignment.
        extra_qw_opts: Additional options to add to existing options for\
            3dQwarp.
        keep_temp: Keep temporary files including awpy directory and other\
            intermediate datasets.
        version: Display the program version.
        ok_to_exist: Reuse and do not overwrite existing datasets.
        echo: Copy all commands being run into the terminal.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@animal_warper",
        "input_file": input_file,
        "base_template": base_template,
        "output_dir": output_dir,
        "no_surfaces": no_surfaces,
        "supersize": supersize,
        "mode_smooth_replacement_off": mode_smooth_replacement_off,
        "keep_temp": keep_temp,
        "version": version,
        "ok_to_exist": ok_to_exist,
        "echo": echo,
    }
    if brainmask is not None:
        params["brainmask"] = brainmask
    if atlases is not None:
        params["atlases"] = atlases
    if atlas_followers is not None:
        params["atlas_followers"] = atlas_followers
    if seg_followers is not None:
        params["seg_followers"] = seg_followers
    if template_followers is not None:
        params["template_followers"] = template_followers
    if dset_followers is not None:
        params["dset_followers"] = dset_followers
    if roidset_followers is not None:
        params["roidset_followers"] = roidset_followers
    if input_abbrev is not None:
        params["input_abbrev"] = input_abbrev
    if base_abbrev is not None:
        params["base_abbrev"] = base_abbrev
    if atlas_abbrevs is not None:
        params["atlas_abbrevs"] = atlas_abbrevs
    if template_abbrevs is not None:
        params["template_abbrevs"] = template_abbrevs
    if seg_abbrevs is not None:
        params["seg_abbrevs"] = seg_abbrevs
    if dset_abbrevs is not None:
        params["dset_abbrevs"] = dset_abbrevs
    if roidset_abbrevs is not None:
        params["roidset_abbrevs"] = roidset_abbrevs
    if align_centers_meth is not None:
        params["align_centers_meth"] = align_centers_meth
    if aff_move_opt is not None:
        params["aff_move_opt"] = aff_move_opt
    if cost is not None:
        params["cost"] = cost
    if maxlev is not None:
        params["maxlev"] = maxlev
    if feature_size is not None:
        params["feature_size"] = feature_size
    if init_scale is not None:
        params["init_scale"] = init_scale
    if mode_smooth_size is not None:
        params["mode_smooth_size"] = mode_smooth_size
    if center_out is not None:
        params["center_out"] = center_out
    if align_type is not None:
        params["align_type"] = align_type
    if extra_qw_opts is not None:
        params["extra_qw_opts"] = extra_qw_opts
    return params


def v__animal_warper_cargs(
    params: VAnimalWarperParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@animal_warper")
    cargs.append(execution.input_file(params.get("input_file", None)))
    cargs.append(execution.input_file(params.get("base_template", None)))
    cargs.append(params.get("output_dir", None))
    if params.get("brainmask", None) is not None:
        cargs.append(execution.input_file(params.get("brainmask", None)))
    if params.get("atlases", None) is not None:
        cargs.extend([
            "-atlas",
            *[execution.input_file(f) for f in params.get("atlases", None)]
        ])
    if params.get("atlas_followers", None) is not None:
        cargs.extend([
            "-atlas_followers",
            *[execution.input_file(f) for f in params.get("atlas_followers", None)]
        ])
    if params.get("seg_followers", None) is not None:
        cargs.extend([
            "-seg_followers",
            *[execution.input_file(f) for f in params.get("seg_followers", None)]
        ])
    if params.get("template_followers", None) is not None:
        cargs.extend([
            "-template_followers",
            *[execution.input_file(f) for f in params.get("template_followers", None)]
        ])
    if params.get("dset_followers", None) is not None:
        cargs.extend([
            "-dset_followers",
            *[execution.input_file(f) for f in params.get("dset_followers", None)]
        ])
    if params.get("roidset_followers", None) is not None:
        cargs.extend([
            "-roidset_followers",
            *[execution.input_file(f) for f in params.get("roidset_followers", None)]
        ])
    if params.get("input_abbrev", None) is not None:
        cargs.extend([
            "-input_abbrev",
            params.get("input_abbrev", None)
        ])
    if params.get("base_abbrev", None) is not None:
        cargs.extend([
            "-base_abbrev",
            params.get("base_abbrev", None)
        ])
    if params.get("atlas_abbrevs", None) is not None:
        cargs.extend([
            "-atlas_abbrevs",
            *params.get("atlas_abbrevs", None)
        ])
    if params.get("template_abbrevs", None) is not None:
        cargs.extend([
            "-template_abbrevs",
            *params.get("template_abbrevs", None)
        ])
    if params.get("seg_abbrevs", None) is not None:
        cargs.extend([
            "-seg_abbrevs",
            *params.get("seg_abbrevs", None)
        ])
    if params.get("dset_abbrevs", None) is not None:
        cargs.extend([
            "-dset_abbrevs",
            *params.get("dset_abbrevs", None)
        ])
    if params.get("roidset_abbrevs", None) is not None:
        cargs.extend([
            "-roidset_abbrevs",
            *params.get("roidset_abbrevs", None)
        ])
    if params.get("align_centers_meth", None) is not None:
        cargs.extend([
            "-align_centers_meth",
            params.get("align_centers_meth", None)
        ])
    if params.get("aff_move_opt", None) is not None:
        cargs.extend([
            "-aff_move_opt",
            params.get("aff_move_opt", None)
        ])
    if params.get("cost", None) is not None:
        cargs.extend([
            "-cost",
            params.get("cost", None)
        ])
    if params.get("maxlev", None) is not None:
        cargs.extend([
            "-maxlev",
            str(params.get("maxlev", None))
        ])
    if params.get("no_surfaces", False):
        cargs.append("-no_surfaces")
    if params.get("feature_size", None) is not None:
        cargs.extend([
            "-feature_size",
            str(params.get("feature_size", None))
        ])
    if params.get("supersize", False):
        cargs.append("-supersize")
    if params.get("init_scale", None) is not None:
        cargs.extend([
            "-init_scale",
            str(params.get("init_scale", None))
        ])
    if params.get("mode_smooth_size", None) is not None:
        cargs.extend([
            "-mode_smooth_size",
            str(params.get("mode_smooth_size", None))
        ])
    if params.get("mode_smooth_replacement_off", False):
        cargs.append("-mode_smooth_replacement_off")
    if params.get("center_out", None) is not None:
        cargs.extend([
            "-center_out",
            params.get("center_out", None)
        ])
    if params.get("align_type", None) is not None:
        cargs.extend([
            "-align_type",
            params.get("align_type", None)
        ])
    if params.get("extra_qw_opts", None) is not None:
        cargs.extend([
            "-extra_qw_opts",
            params.get("extra_qw_opts", None)
        ])
    if params.get("keep_temp", False):
        cargs.append("-keep_temp")
    if params.get("version", False):
        cargs.append("-ver")
    if params.get("ok_to_exist", False):
        cargs.append("-ok_to_exist")
    if params.get("echo", False):
        cargs.append("-echo")
    return cargs


def v__animal_warper_outputs(
    params: VAnimalWarperParameters,
    execution: Execution,
) -> VAnimalWarperOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAnimalWarperOutputs(
        root=execution.output_file("."),
        warp2std=execution.output_file("aw_results/" + pathlib.Path(params.get("input_file", None)).name + "_warp2std.nii.gz"),
        qc_image_initial=execution.output_file("aw_results/init_qc_00.input+base.jpg"),
        qc_image_initial_sh=execution.output_file("aw_results/init_qc_01.input_sh+base.jpg"),
        dset_followers_out=execution.output_file("aw_results/DSET_FOLL.nii.gz"),
        roidset_followers_out=execution.output_file("aw_results/ROIDSET_FOLL.nii.gz"),
        animal_outs_guide=execution.output_file("aw_results/animal_outs.txt"),
    )
    return ret


def v__animal_warper_execute(
    params: VAnimalWarperParameters,
    runner: Runner | None = None,
) -> VAnimalWarperOutputs:
    """
    @animal_warper
    
    Align a subject structural dataset to a template and perform several
    post-alignment operations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAnimalWarperOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__ANIMAL_WARPER_METADATA)
    params = execution.params(params)
    cargs = v__animal_warper_cargs(params, execution)
    ret = v__animal_warper_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__animal_warper(
    input_file: InputPathType,
    base_template: InputPathType,
    output_dir: str,
    brainmask: InputPathType | None = None,
    atlases: list[InputPathType] | None = None,
    atlas_followers: list[InputPathType] | None = None,
    seg_followers: list[InputPathType] | None = None,
    template_followers: list[InputPathType] | None = None,
    dset_followers: list[InputPathType] | None = None,
    roidset_followers: list[InputPathType] | None = None,
    input_abbrev: str | None = None,
    base_abbrev: str | None = None,
    atlas_abbrevs: list[str] | None = None,
    template_abbrevs: list[str] | None = None,
    seg_abbrevs: list[str] | None = None,
    dset_abbrevs: list[str] | None = None,
    roidset_abbrevs: list[str] | None = None,
    align_centers_meth: str | None = None,
    aff_move_opt: str | None = None,
    cost: str | None = None,
    maxlev: float | None = None,
    no_surfaces: bool = False,
    feature_size: float | None = None,
    supersize: bool = False,
    init_scale: float | None = None,
    mode_smooth_size: float | None = None,
    mode_smooth_replacement_off: bool = False,
    center_out: str | None = None,
    align_type: str | None = None,
    extra_qw_opts: str | None = None,
    keep_temp: bool = False,
    version: bool = False,
    ok_to_exist: bool = False,
    echo: bool = False,
    runner: Runner | None = None,
) -> VAnimalWarperOutputs:
    """
    @animal_warper
    
    Align a subject structural dataset to a template and perform several
    post-alignment operations.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: input dataset to align to base template.
        base_template: base dataset (template) to align with.
        output_dir: output directory where all processing will be performed.
        brainmask: provide a brainmask in the base template space.
        atlases: one or more atlas datasets in the base volume space.
        atlas_followers: one or more atlas datasets in the base volume space.
        seg_followers: one or more segmentation datasets in the base volume\
            space.
        template_followers: one or more datasets in the template volume space.
        dset_followers: one or more datasets in the input volume space.
        roidset_followers: one or more (int-valued) datasets in the input\
            volume space.
        input_abbrev: specify abbreviation for input dataset.
        base_abbrev: specify abbreviation for base dataset.
        atlas_abbrevs: specify an abbreviation for each atlas follower dataset.
        template_abbrevs: specify an abbreviation for each template follower\
            dataset.
        seg_abbrevs: specify an abbreviation for each segmentation follower\
            dataset.
        dset_abbrevs: specify an abbreviation for each dataset follower dataset.
        roidset_abbrevs: specify an abbreviation for each ROI dataset follower\
            dataset.
        align_centers_meth: center alignment method to use.
        aff_move_opt: alignment movement options for affine alignment step.
        cost: cost function for affine and nonlinear alignment.
        maxlev: Max level for nonlinear warping. Final patch size is determined\
            based on this value.
        no_surfaces: Do not make surfaces for atlas regions in native space.
        feature_size: Set feature size for affine alignment (in mm).
        supersize: Allow up to 50% size difference between subject and template.
        init_scale: Approximate length ratio of input to template for initial\
            scaling.
        mode_smooth_size: Modal smoothing kernel size in voxels.
        mode_smooth_replacement_off: Turn off replacement in modal smoothing.
        center_out: Center native-space output to native original space or\
            template space center-shifted.
        align_type: Specify level of alignment.
        extra_qw_opts: Additional options to add to existing options for\
            3dQwarp.
        keep_temp: Keep temporary files including awpy directory and other\
            intermediate datasets.
        version: Display the program version.
        ok_to_exist: Reuse and do not overwrite existing datasets.
        echo: Copy all commands being run into the terminal.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAnimalWarperOutputs`).
    """
    params = v__animal_warper_params(
        input_file=input_file,
        base_template=base_template,
        output_dir=output_dir,
        brainmask=brainmask,
        atlases=atlases,
        atlas_followers=atlas_followers,
        seg_followers=seg_followers,
        template_followers=template_followers,
        dset_followers=dset_followers,
        roidset_followers=roidset_followers,
        input_abbrev=input_abbrev,
        base_abbrev=base_abbrev,
        atlas_abbrevs=atlas_abbrevs,
        template_abbrevs=template_abbrevs,
        seg_abbrevs=seg_abbrevs,
        dset_abbrevs=dset_abbrevs,
        roidset_abbrevs=roidset_abbrevs,
        align_centers_meth=align_centers_meth,
        aff_move_opt=aff_move_opt,
        cost=cost,
        maxlev=maxlev,
        no_surfaces=no_surfaces,
        feature_size=feature_size,
        supersize=supersize,
        init_scale=init_scale,
        mode_smooth_size=mode_smooth_size,
        mode_smooth_replacement_off=mode_smooth_replacement_off,
        center_out=center_out,
        align_type=align_type,
        extra_qw_opts=extra_qw_opts,
        keep_temp=keep_temp,
        version=version,
        ok_to_exist=ok_to_exist,
        echo=echo,
    )
    return v__animal_warper_execute(params, runner)


__all__ = [
    "VAnimalWarperOutputs",
    "V__ANIMAL_WARPER_METADATA",
    "v__animal_warper",
    "v__animal_warper_execute",
    "v__animal_warper_params",
]
