# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__AUTO_TLRC_METADATA = Metadata(
    id="9ec14a3c3a060032a8913afb5801da9608c8ae87.boutiques",
    name="@auto_tlrc",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VAutoTlrcParameters = typing.TypedDict('VAutoTlrcParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@auto_tlrc"]],
    "base_template": InputPathType,
    "input_anat": InputPathType,
    "no_ss": bool,
    "warp_orig_vol": bool,
    "dxyz": typing.NotRequired[float | None],
    "dx": typing.NotRequired[float | None],
    "dy": typing.NotRequired[float | None],
    "dz": typing.NotRequired[float | None],
    "pad_base": typing.NotRequired[float | None],
    "keep_tmp": bool,
    "clean": bool,
    "xform": typing.NotRequired[str | None],
    "no_avoid_eyes": bool,
    "ncr": bool,
    "onepass": bool,
    "twopass": bool,
    "maxite": typing.NotRequired[float | None],
    "not_OK_maxite": bool,
    "inweight": bool,
    "rigid_equiv": bool,
    "init_xform": typing.NotRequired[str | None],
    "no_pre": bool,
    "out_space": typing.NotRequired[str | None],
    "3dAllineate": bool,
    "3dAlcost": typing.NotRequired[str | None],
    "overwrite": bool,
    "apar": InputPathType,
    "input_dataset": InputPathType,
    "pad_input": typing.NotRequired[float | None],
    "onewarp": bool,
    "twowarp": bool,
    "rmode": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "keep_view": bool,
    "base_copy": typing.NotRequired[str | None],
    "base_list": bool,
    "use_gz": bool,
    "verb": bool,
})
VAutoTlrcParametersTagged = typing.TypedDict('VAutoTlrcParametersTagged', {
    "@type": typing.Literal["afni/@auto_tlrc"],
    "base_template": InputPathType,
    "input_anat": InputPathType,
    "no_ss": bool,
    "warp_orig_vol": bool,
    "dxyz": typing.NotRequired[float | None],
    "dx": typing.NotRequired[float | None],
    "dy": typing.NotRequired[float | None],
    "dz": typing.NotRequired[float | None],
    "pad_base": typing.NotRequired[float | None],
    "keep_tmp": bool,
    "clean": bool,
    "xform": typing.NotRequired[str | None],
    "no_avoid_eyes": bool,
    "ncr": bool,
    "onepass": bool,
    "twopass": bool,
    "maxite": typing.NotRequired[float | None],
    "not_OK_maxite": bool,
    "inweight": bool,
    "rigid_equiv": bool,
    "init_xform": typing.NotRequired[str | None],
    "no_pre": bool,
    "out_space": typing.NotRequired[str | None],
    "3dAllineate": bool,
    "3dAlcost": typing.NotRequired[str | None],
    "overwrite": bool,
    "apar": InputPathType,
    "input_dataset": InputPathType,
    "pad_input": typing.NotRequired[float | None],
    "onewarp": bool,
    "twowarp": bool,
    "rmode": typing.NotRequired[str | None],
    "prefix": typing.NotRequired[str | None],
    "suffix": typing.NotRequired[str | None],
    "keep_view": bool,
    "base_copy": typing.NotRequired[str | None],
    "base_list": bool,
    "use_gz": bool,
    "verb": bool,
})


class VAutoTlrcOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VAutoTlrcParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType | None
    """Transformed anatomical volume dataset in TLRC space."""
    transform_file: OutputPathType | None
    """Transform used to align the anatomical dataset to the template."""


def v__auto_tlrc_params(
    base_template: InputPathType,
    input_anat: InputPathType,
    apar: InputPathType,
    input_dataset: InputPathType,
    no_ss: bool = False,
    warp_orig_vol: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
    pad_base: float | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    xform: str | None = None,
    no_avoid_eyes: bool = False,
    ncr: bool = False,
    onepass: bool = False,
    twopass: bool = False,
    maxite: float | None = None,
    not_ok_maxite: bool = False,
    inweight: bool = False,
    rigid_equiv: bool = False,
    init_xform: str | None = None,
    no_pre: bool = False,
    out_space: str | None = None,
    v_3d_allineate: bool = False,
    v_3d_alcost: str | None = None,
    overwrite: bool = False,
    pad_input: float | None = None,
    onewarp: bool = False,
    twowarp: bool = False,
    rmode: str | None = None,
    prefix: str | None = None,
    suffix: str | None = None,
    keep_view: bool = False,
    base_copy: str | None = None,
    base_list: bool = False,
    use_gz: bool = False,
    verb: bool = False,
) -> VAutoTlrcParametersTagged:
    """
    Build parameters.
    
    Args:
        base_template: Reference anatomical volume. Usually this volume is in\
            some standard space like TLRC or MNI space.
        input_anat: Original anatomical volume (+orig). The skull is removed by\
            this script unless instructed otherwise (-no_ss).
        apar: An anatomical dataset in TLRC space created using Usage 1 of\
            @auto_tlrc.
        input_dataset: Dataset (typically EPI time series or statistical\
            dataset) to transform to TLRC space per the transform in TLRC_parent.
        no_ss: Do not strip skull of input data set because the skull has\
            already been removed or because the template still has the skull.
        warp_orig_vol: Produce a TLRC version of the input volume, rather than\
            a TLRC version of the skull-stripped input.
        dxyz: Cubic voxel size of output DSET in TLRC space. Default is the\
            resolution of the template.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
        pad_base: Pad the base dataset by MM mm in each direction. Default is\
            15 mm.
        keep_tmp: Keep temporary files.
        clean: Clean all temporary files, likely left from -keep_tmp option\
            then exit.
        xform: Transform to use for warping: Choose from affine_general or\
            shift_rotate_scale. Default is affine_general.
        no_avoid_eyes: An option that gets passed to 3dSkullStrip. Use it when\
            parts of the frontal lobes get clipped.
        ncr: Do not use -coarserot option for 3dWarpDrive, which is a default.
        onepass: Turns off -twopass option for 3dWarpDrive. This will speed up\
            the registration but might fail if the datasets are far apart.
        twopass: Opposite of -onepass, default.
        maxite: Maximum number of iterations for 3dWarpDrive. Default is 50 for\
            first pass and then doubled to 100 in second pass.
        not_ok_maxite: Continue running even if maximum iterations is reached.
        inweight: Apply -weight INPUT (in 3dWarpDrive). By default, 3dWarpDrive\
            uses the BASE dataset to weight the alignment cost.
        rigid_equiv: Output the rigid-body version of the alignment. Resultant\
            volume is NOT in TLRC space.
        init_xform: Apply affine transform in XFORM0.1D before beginning\
            registration and then include XFORM0.1D in the final transform.
        no_pre: Delete temporary dataset created by -init_xform.
        out_space: Set the output to a particular space.
        v_3d_allineate: Use 3dAllineate with the lpa+ZZ cost function instead\
            of 3dWarpDrive.
        v_3d_alcost: Use another cost function like nmi for 3dAllineate.
        overwrite: Overwrite existing output.
        pad_input: Pad the input dataset by MM mm in each direction.
        onewarp: Create follower data with one interpolation step, instead of\
            two. This option reduces blurring of the output data.
        twowarp: Create follower data with two interpolations step, instead of\
            one. This option is for backward compatibility.
        rmode: Resampling mode. Choose from: linear, cubic, NN or quintic.\
            Default for 'Usage 1' is cubic.
        prefix: Name of the output dataset.
        suffix: Name the output dataset by appending this suffix to the prefix\
            of the input data.
        keep_view: Do not mark output dataset as +tlrc.
        base_copy: Copy base (template) dataset into COPY_PREFIX.
        base_list: List the full path of the base dataset.
        use_gz: When using '-suffix ..', behave as if you had provided a prefix\
            with '*.gz' at the end.
        verb: Increase verbosity of the script.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@auto_tlrc",
        "base_template": base_template,
        "input_anat": input_anat,
        "no_ss": no_ss,
        "warp_orig_vol": warp_orig_vol,
        "keep_tmp": keep_tmp,
        "clean": clean,
        "no_avoid_eyes": no_avoid_eyes,
        "ncr": ncr,
        "onepass": onepass,
        "twopass": twopass,
        "not_OK_maxite": not_ok_maxite,
        "inweight": inweight,
        "rigid_equiv": rigid_equiv,
        "no_pre": no_pre,
        "3dAllineate": v_3d_allineate,
        "overwrite": overwrite,
        "apar": apar,
        "input_dataset": input_dataset,
        "onewarp": onewarp,
        "twowarp": twowarp,
        "keep_view": keep_view,
        "base_list": base_list,
        "use_gz": use_gz,
        "verb": verb,
    }
    if dxyz is not None:
        params["dxyz"] = dxyz
    if dx is not None:
        params["dx"] = dx
    if dy is not None:
        params["dy"] = dy
    if dz is not None:
        params["dz"] = dz
    if pad_base is not None:
        params["pad_base"] = pad_base
    if xform is not None:
        params["xform"] = xform
    if maxite is not None:
        params["maxite"] = maxite
    if init_xform is not None:
        params["init_xform"] = init_xform
    if out_space is not None:
        params["out_space"] = out_space
    if v_3d_alcost is not None:
        params["3dAlcost"] = v_3d_alcost
    if pad_input is not None:
        params["pad_input"] = pad_input
    if rmode is not None:
        params["rmode"] = rmode
    if prefix is not None:
        params["prefix"] = prefix
    if suffix is not None:
        params["suffix"] = suffix
    if base_copy is not None:
        params["base_copy"] = base_copy
    return params


def v__auto_tlrc_cargs(
    params: VAutoTlrcParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@auto_tlrc")
    cargs.extend([
        "-base",
        execution.input_file(params.get("base_template", None))
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_anat", None))
    ])
    if params.get("no_ss", False):
        cargs.append("-no_ss")
    if params.get("warp_orig_vol", False):
        cargs.append("-warp_orig_vol")
    if params.get("dxyz", None) is not None:
        cargs.extend([
            "-dxyz",
            str(params.get("dxyz", None))
        ])
    if params.get("dx", None) is not None:
        cargs.extend([
            "-dx",
            str(params.get("dx", None))
        ])
    if params.get("dy", None) is not None:
        cargs.extend([
            "-dy",
            str(params.get("dy", None))
        ])
    if params.get("dz", None) is not None:
        cargs.extend([
            "-dz",
            str(params.get("dz", None))
        ])
    if params.get("pad_base", None) is not None:
        cargs.extend([
            "-pad_base",
            str(params.get("pad_base", None))
        ])
    if params.get("keep_tmp", False):
        cargs.append("-keep_tmp")
    if params.get("clean", False):
        cargs.append("-clean")
    if params.get("xform", None) is not None:
        cargs.extend([
            "-xform",
            params.get("xform", None)
        ])
    if params.get("no_avoid_eyes", False):
        cargs.append("-no_avoid_eyes")
    if params.get("ncr", False):
        cargs.append("-ncr")
    if params.get("onepass", False):
        cargs.append("-onepass")
    if params.get("twopass", False):
        cargs.append("-twopass")
    if params.get("maxite", None) is not None:
        cargs.extend([
            "-maxite",
            str(params.get("maxite", None))
        ])
    if params.get("not_OK_maxite", False):
        cargs.append("-not_OK_maxite")
    if params.get("inweight", False):
        cargs.append("-inweight")
    if params.get("rigid_equiv", False):
        cargs.append("-rigid_equiv")
    if params.get("init_xform", None) is not None:
        cargs.extend([
            "-init_xform",
            params.get("init_xform", None)
        ])
    if params.get("no_pre", False):
        cargs.append("-no_pre")
    if params.get("out_space", None) is not None:
        cargs.extend([
            "-out_space",
            params.get("out_space", None)
        ])
    if params.get("3dAllineate", False):
        cargs.append("-3dAllineate")
    if params.get("3dAlcost", None) is not None:
        cargs.extend([
            "-3dAlcost",
            params.get("3dAlcost", None)
        ])
    if params.get("overwrite", False):
        cargs.append("-overwrite")
    cargs.extend([
        "-apar",
        execution.input_file(params.get("apar", None))
    ])
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_dataset", None))
    ])
    if params.get("pad_input", None) is not None:
        cargs.extend([
            "-pad_input",
            str(params.get("pad_input", None))
        ])
    if params.get("onewarp", False):
        cargs.append("-onewarp")
    if params.get("twowarp", False):
        cargs.append("-twowarp")
    if params.get("rmode", None) is not None:
        cargs.extend([
            "-rmode",
            params.get("rmode", None)
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    if params.get("keep_view", False):
        cargs.append("-keep_view")
    if params.get("base_copy", None) is not None:
        cargs.extend([
            "-base_copy",
            params.get("base_copy", None)
        ])
    if params.get("base_list", False):
        cargs.append("-base_list")
    if params.get("use_gz", False):
        cargs.append("-use_gz")
    if params.get("verb", False):
        cargs.append("-verb")
    return cargs


def v__auto_tlrc_outputs(
    params: VAutoTlrcParameters,
    execution: Execution,
) -> VAutoTlrcOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VAutoTlrcOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + ".nii.gz") if (params.get("prefix") is not None) else None,
        transform_file=execution.output_file(params.get("prefix", None) + ".Xat.1D") if (params.get("prefix") is not None) else None,
    )
    return ret


def v__auto_tlrc_execute(
    params: VAutoTlrcParameters,
    runner: Runner | None = None,
) -> VAutoTlrcOutputs:
    """
    @auto_tlrc
    
    A script to transform an anatomical dataset to align with some standard
    space template and to apply the same TLRC transform obtained with @auto_tlrc
    in Usage 1 mode to other datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAutoTlrcOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__AUTO_TLRC_METADATA)
    params = execution.params(params)
    cargs = v__auto_tlrc_cargs(params, execution)
    ret = v__auto_tlrc_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__auto_tlrc(
    base_template: InputPathType,
    input_anat: InputPathType,
    apar: InputPathType,
    input_dataset: InputPathType,
    no_ss: bool = False,
    warp_orig_vol: bool = False,
    dxyz: float | None = None,
    dx: float | None = None,
    dy: float | None = None,
    dz: float | None = None,
    pad_base: float | None = None,
    keep_tmp: bool = False,
    clean: bool = False,
    xform: str | None = None,
    no_avoid_eyes: bool = False,
    ncr: bool = False,
    onepass: bool = False,
    twopass: bool = False,
    maxite: float | None = None,
    not_ok_maxite: bool = False,
    inweight: bool = False,
    rigid_equiv: bool = False,
    init_xform: str | None = None,
    no_pre: bool = False,
    out_space: str | None = None,
    v_3d_allineate: bool = False,
    v_3d_alcost: str | None = None,
    overwrite: bool = False,
    pad_input: float | None = None,
    onewarp: bool = False,
    twowarp: bool = False,
    rmode: str | None = None,
    prefix: str | None = None,
    suffix: str | None = None,
    keep_view: bool = False,
    base_copy: str | None = None,
    base_list: bool = False,
    use_gz: bool = False,
    verb: bool = False,
    runner: Runner | None = None,
) -> VAutoTlrcOutputs:
    """
    @auto_tlrc
    
    A script to transform an anatomical dataset to align with some standard
    space template and to apply the same TLRC transform obtained with @auto_tlrc
    in Usage 1 mode to other datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        base_template: Reference anatomical volume. Usually this volume is in\
            some standard space like TLRC or MNI space.
        input_anat: Original anatomical volume (+orig). The skull is removed by\
            this script unless instructed otherwise (-no_ss).
        apar: An anatomical dataset in TLRC space created using Usage 1 of\
            @auto_tlrc.
        input_dataset: Dataset (typically EPI time series or statistical\
            dataset) to transform to TLRC space per the transform in TLRC_parent.
        no_ss: Do not strip skull of input data set because the skull has\
            already been removed or because the template still has the skull.
        warp_orig_vol: Produce a TLRC version of the input volume, rather than\
            a TLRC version of the skull-stripped input.
        dxyz: Cubic voxel size of output DSET in TLRC space. Default is the\
            resolution of the template.
        dx: Size of voxel in the x direction (Right-Left). Default is 1mm.
        dy: Size of voxel in the y direction (Anterior-Posterior). Default is\
            1mm.
        dz: Size of voxel in the z direction (Inferior-Superior). Default is\
            1mm.
        pad_base: Pad the base dataset by MM mm in each direction. Default is\
            15 mm.
        keep_tmp: Keep temporary files.
        clean: Clean all temporary files, likely left from -keep_tmp option\
            then exit.
        xform: Transform to use for warping: Choose from affine_general or\
            shift_rotate_scale. Default is affine_general.
        no_avoid_eyes: An option that gets passed to 3dSkullStrip. Use it when\
            parts of the frontal lobes get clipped.
        ncr: Do not use -coarserot option for 3dWarpDrive, which is a default.
        onepass: Turns off -twopass option for 3dWarpDrive. This will speed up\
            the registration but might fail if the datasets are far apart.
        twopass: Opposite of -onepass, default.
        maxite: Maximum number of iterations for 3dWarpDrive. Default is 50 for\
            first pass and then doubled to 100 in second pass.
        not_ok_maxite: Continue running even if maximum iterations is reached.
        inweight: Apply -weight INPUT (in 3dWarpDrive). By default, 3dWarpDrive\
            uses the BASE dataset to weight the alignment cost.
        rigid_equiv: Output the rigid-body version of the alignment. Resultant\
            volume is NOT in TLRC space.
        init_xform: Apply affine transform in XFORM0.1D before beginning\
            registration and then include XFORM0.1D in the final transform.
        no_pre: Delete temporary dataset created by -init_xform.
        out_space: Set the output to a particular space.
        v_3d_allineate: Use 3dAllineate with the lpa+ZZ cost function instead\
            of 3dWarpDrive.
        v_3d_alcost: Use another cost function like nmi for 3dAllineate.
        overwrite: Overwrite existing output.
        pad_input: Pad the input dataset by MM mm in each direction.
        onewarp: Create follower data with one interpolation step, instead of\
            two. This option reduces blurring of the output data.
        twowarp: Create follower data with two interpolations step, instead of\
            one. This option is for backward compatibility.
        rmode: Resampling mode. Choose from: linear, cubic, NN or quintic.\
            Default for 'Usage 1' is cubic.
        prefix: Name of the output dataset.
        suffix: Name the output dataset by appending this suffix to the prefix\
            of the input data.
        keep_view: Do not mark output dataset as +tlrc.
        base_copy: Copy base (template) dataset into COPY_PREFIX.
        base_list: List the full path of the base dataset.
        use_gz: When using '-suffix ..', behave as if you had provided a prefix\
            with '*.gz' at the end.
        verb: Increase verbosity of the script.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VAutoTlrcOutputs`).
    """
    params = v__auto_tlrc_params(
        base_template=base_template,
        input_anat=input_anat,
        no_ss=no_ss,
        warp_orig_vol=warp_orig_vol,
        dxyz=dxyz,
        dx=dx,
        dy=dy,
        dz=dz,
        pad_base=pad_base,
        keep_tmp=keep_tmp,
        clean=clean,
        xform=xform,
        no_avoid_eyes=no_avoid_eyes,
        ncr=ncr,
        onepass=onepass,
        twopass=twopass,
        maxite=maxite,
        not_ok_maxite=not_ok_maxite,
        inweight=inweight,
        rigid_equiv=rigid_equiv,
        init_xform=init_xform,
        no_pre=no_pre,
        out_space=out_space,
        v_3d_allineate=v_3d_allineate,
        v_3d_alcost=v_3d_alcost,
        overwrite=overwrite,
        apar=apar,
        input_dataset=input_dataset,
        pad_input=pad_input,
        onewarp=onewarp,
        twowarp=twowarp,
        rmode=rmode,
        prefix=prefix,
        suffix=suffix,
        keep_view=keep_view,
        base_copy=base_copy,
        base_list=base_list,
        use_gz=use_gz,
        verb=verb,
    )
    return v__auto_tlrc_execute(params, runner)


__all__ = [
    "VAutoTlrcOutputs",
    "V__AUTO_TLRC_METADATA",
    "v__auto_tlrc",
    "v__auto_tlrc_execute",
    "v__auto_tlrc_params",
]
