# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__BUILD_AFNI_XLIB_METADATA = Metadata(
    id="6d2e574b4e7a94571cef3ddf151a833feef4d14a.boutiques",
    name="@build_afni_Xlib",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VBuildAfniXlibParameters = typing.TypedDict('VBuildAfniXlibParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@build_afni_Xlib"]],
    "afniX": bool,
    "localinstall": bool,
    "debug_symbols": bool,
    "lib32": bool,
    "lib64": bool,
    "packages": list[str],
})
VBuildAfniXlibParametersTagged = typing.TypedDict('VBuildAfniXlibParametersTagged', {
    "@type": typing.Literal["afni/@build_afni_Xlib"],
    "afniX": bool,
    "localinstall": bool,
    "debug_symbols": bool,
    "lib32": bool,
    "lib64": bool,
    "packages": list[str],
})


class VBuildAfniXlibOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VBuildAfniXlibParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__build_afni_xlib_params(
    packages: list[str],
    afni_x: bool = False,
    localinstall: bool = False,
    debug_symbols: bool = False,
    lib32: bool = False,
    lib64: bool = False,
) -> VBuildAfniXlibParametersTagged:
    """
    Build parameters.
    
    Args:
        packages: Packages to compile and install (e.g., lesstif, openmotif,\
            libXt).
        afni_x: Install under /usr/local/afniX.
        localinstall: Install under each package directory.
        debug_symbols: Compile with -g to add symbols.
        lib32: Install libs under lib, and force 32-bit compile (on Linux: add\
            --target=i386).
        lib64: Install libs under lib64 (default is lib).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@build_afni_Xlib",
        "afniX": afni_x,
        "localinstall": localinstall,
        "debug_symbols": debug_symbols,
        "lib32": lib32,
        "lib64": lib64,
        "packages": packages,
    }
    return params


def v__build_afni_xlib_cargs(
    params: VBuildAfniXlibParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@build_afni_Xlib")
    if params.get("afniX", False):
        cargs.append("-afniX")
    if params.get("localinstall", False):
        cargs.append("-localinstall")
    if params.get("debug_symbols", False):
        cargs.append("-g")
    if params.get("lib32", False):
        cargs.append("-lib32")
    if params.get("lib64", False):
        cargs.append("-lib64")
    cargs.extend(params.get("packages", None))
    return cargs


def v__build_afni_xlib_outputs(
    params: VBuildAfniXlibParameters,
    execution: Execution,
) -> VBuildAfniXlibOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VBuildAfniXlibOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__build_afni_xlib_execute(
    params: VBuildAfniXlibParameters,
    runner: Runner | None = None,
) -> VBuildAfniXlibOutputs:
    """
    @build_afni_Xlib
    
    Compile and install lesstif, openmotif, and/or libXt.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VBuildAfniXlibOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__BUILD_AFNI_XLIB_METADATA)
    params = execution.params(params)
    cargs = v__build_afni_xlib_cargs(params, execution)
    ret = v__build_afni_xlib_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__build_afni_xlib(
    packages: list[str],
    afni_x: bool = False,
    localinstall: bool = False,
    debug_symbols: bool = False,
    lib32: bool = False,
    lib64: bool = False,
    runner: Runner | None = None,
) -> VBuildAfniXlibOutputs:
    """
    @build_afni_Xlib
    
    Compile and install lesstif, openmotif, and/or libXt.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        packages: Packages to compile and install (e.g., lesstif, openmotif,\
            libXt).
        afni_x: Install under /usr/local/afniX.
        localinstall: Install under each package directory.
        debug_symbols: Compile with -g to add symbols.
        lib32: Install libs under lib, and force 32-bit compile (on Linux: add\
            --target=i386).
        lib64: Install libs under lib64 (default is lib).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VBuildAfniXlibOutputs`).
    """
    params = v__build_afni_xlib_params(
        afni_x=afni_x,
        localinstall=localinstall,
        debug_symbols=debug_symbols,
        lib32=lib32,
        lib64=lib64,
        packages=packages,
    )
    return v__build_afni_xlib_execute(params, runner)


__all__ = [
    "VBuildAfniXlibOutputs",
    "V__BUILD_AFNI_XLIB_METADATA",
    "v__build_afni_xlib",
    "v__build_afni_xlib_execute",
    "v__build_afni_xlib_params",
]
