# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__CENTER_DISTANCE_METADATA = Metadata(
    id="f179e8348e56e5e6c674b858f8ada01c7b1547c8.boutiques",
    name="@Center_Distance",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VCenterDistanceParameters = typing.TypedDict('VCenterDistanceParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@Center_Distance"]],
    "dset1": InputPathType,
    "dset2": InputPathType,
})
VCenterDistanceParametersTagged = typing.TypedDict('VCenterDistanceParametersTagged', {
    "@type": typing.Literal["afni/@Center_Distance"],
    "dset1": InputPathType,
    "dset2": InputPathType,
})


class VCenterDistanceOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VCenterDistanceParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    distance_output: OutputPathType
    """The calculated distance between the centers of DSET_1 and DSET_2"""


def v__center_distance_params(
    dset1: InputPathType,
    dset2: InputPathType,
) -> VCenterDistanceParametersTagged:
    """
    Build parameters.
    
    Args:
        dset1: First dataset file (e.g. file1.nii.gz).
        dset2: Second dataset file (e.g. file2.nii.gz).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@Center_Distance",
        "dset1": dset1,
        "dset2": dset2,
    }
    return params


def v__center_distance_cargs(
    params: VCenterDistanceParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@Center_Distance")
    cargs.extend([
        "-dset",
        execution.input_file(params.get("dset1", None))
    ])
    cargs.append(execution.input_file(params.get("dset2", None)))
    return cargs


def v__center_distance_outputs(
    params: VCenterDistanceParameters,
    execution: Execution,
) -> VCenterDistanceOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VCenterDistanceOutputs(
        root=execution.output_file("."),
        distance_output=execution.output_file("distance.txt"),
    )
    return ret


def v__center_distance_execute(
    params: VCenterDistanceParameters,
    runner: Runner | None = None,
) -> VCenterDistanceOutputs:
    """
    @Center_Distance
    
    Tool to calculate the distance between the centers of two datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VCenterDistanceOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__CENTER_DISTANCE_METADATA)
    params = execution.params(params)
    cargs = v__center_distance_cargs(params, execution)
    ret = v__center_distance_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__center_distance(
    dset1: InputPathType,
    dset2: InputPathType,
    runner: Runner | None = None,
) -> VCenterDistanceOutputs:
    """
    @Center_Distance
    
    Tool to calculate the distance between the centers of two datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset1: First dataset file (e.g. file1.nii.gz).
        dset2: Second dataset file (e.g. file2.nii.gz).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VCenterDistanceOutputs`).
    """
    params = v__center_distance_params(
        dset1=dset1,
        dset2=dset2,
    )
    return v__center_distance_execute(params, runner)


__all__ = [
    "VCenterDistanceOutputs",
    "V__CENTER_DISTANCE_METADATA",
    "v__center_distance",
    "v__center_distance_execute",
    "v__center_distance_params",
]
