# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__CHAUFFEUR_AFNI_METADATA = Metadata(
    id="4609be51012a76cf4219d77097d6e737c6301a9a.boutiques",
    name="@chauffeur_afni",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VChauffeurAfniParameters = typing.TypedDict('VChauffeurAfniParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@chauffeur_afni"]],
    "ulay": InputPathType,
    "olay": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "mode_4D": bool,
    "func_range": typing.NotRequired[float | None],
    "opacity": typing.NotRequired[float | None],
    "set_subbricks": typing.NotRequired[str | None],
    "montx": typing.NotRequired[float | None],
    "monty": typing.NotRequired[float | None],
    "montgap": typing.NotRequired[float | None],
    "label_mode": typing.NotRequired[float | None],
    "label_size": typing.NotRequired[float | None],
    "label_color": typing.NotRequired[str | None],
    "label_setback": typing.NotRequired[float | None],
    "no_clean": bool,
    "do_clean": bool,
    "help": bool,
    "version": bool,
})
VChauffeurAfniParametersTagged = typing.TypedDict('VChauffeurAfniParametersTagged', {
    "@type": typing.Literal["afni/@chauffeur_afni"],
    "ulay": InputPathType,
    "olay": typing.NotRequired[InputPathType | None],
    "prefix": str,
    "mode_4D": bool,
    "func_range": typing.NotRequired[float | None],
    "opacity": typing.NotRequired[float | None],
    "set_subbricks": typing.NotRequired[str | None],
    "montx": typing.NotRequired[float | None],
    "monty": typing.NotRequired[float | None],
    "montgap": typing.NotRequired[float | None],
    "label_mode": typing.NotRequired[float | None],
    "label_size": typing.NotRequired[float | None],
    "label_color": typing.NotRequired[str | None],
    "label_setback": typing.NotRequired[float | None],
    "no_clean": bool,
    "do_clean": bool,
    "help": bool,
    "version": bool,
})


class VChauffeurAfniOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VChauffeurAfniParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_image: OutputPathType
    """Generated montage image"""
    cluster_report: OutputPathType
    """Clusterization report"""
    whereami_report: OutputPathType
    """Whereami report for clusterized data"""


def v__chauffeur_afni_params(
    ulay: InputPathType,
    prefix: str,
    olay: InputPathType | None = None,
    mode_4_d: bool = False,
    func_range: float | None = None,
    opacity: float | None = None,
    set_subbricks: str | None = None,
    montx: float | None = None,
    monty: float | None = None,
    montgap: float | None = None,
    label_mode: float | None = None,
    label_size: float | None = None,
    label_color: str | None = None,
    label_setback: float | None = None,
    no_clean: bool = False,
    do_clean: bool = False,
    help_: bool = False,
    version: bool = False,
) -> VChauffeurAfniParametersTagged:
    """
    Build parameters.
    
    Args:
        ulay: Name of underlay dataset (required); can be 3D or 4D set.
        prefix: Prefix for output files (required).
        olay: Name of overlay dataset (optional).
        mode_4_d: For each viewing plane, one slice is selected across all\
            volumes in a 4D dataset.
        func_range: Specify upper value of the overlay dataset to be matched to\
            top of colorbar (default: 98%ile non-zero value of dataset).
        opacity: Enter an opacity factor for the overlay (0-9, with 9 being\
            opaque).
        set_subbricks: Specify subbricks for 3D image viewing.
        montx: Number of image panels in a row (default: 3).
        monty: Number of image panels in a column (default: 3).
        montgap: Number of pixels as gap between image panels (default: 0).
        label_mode: Control labels, ON/OFF and location (default: 1).
        label_size: Control labels, size (default: 3).
        label_color: Control labels, color (default: white).
        label_setback: Control labels, offset from edge (default: 0.01).
        no_clean: Do not remove the temporary directory of copied/intermediate\
            files.
        do_clean: Remove the temporary directory of copied/intermediate files.
        help_: Display help information.
        version: Display version number.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@chauffeur_afni",
        "ulay": ulay,
        "prefix": prefix,
        "mode_4D": mode_4_d,
        "no_clean": no_clean,
        "do_clean": do_clean,
        "help": help_,
        "version": version,
    }
    if olay is not None:
        params["olay"] = olay
    if func_range is not None:
        params["func_range"] = func_range
    if opacity is not None:
        params["opacity"] = opacity
    if set_subbricks is not None:
        params["set_subbricks"] = set_subbricks
    if montx is not None:
        params["montx"] = montx
    if monty is not None:
        params["monty"] = monty
    if montgap is not None:
        params["montgap"] = montgap
    if label_mode is not None:
        params["label_mode"] = label_mode
    if label_size is not None:
        params["label_size"] = label_size
    if label_color is not None:
        params["label_color"] = label_color
    if label_setback is not None:
        params["label_setback"] = label_setback
    return params


def v__chauffeur_afni_cargs(
    params: VChauffeurAfniParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@chauffeur_afni")
    cargs.append(execution.input_file(params.get("ulay", None)))
    if params.get("olay", None) is not None:
        cargs.append(execution.input_file(params.get("olay", None)))
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("mode_4D", False):
        cargs.append("-mode_4D")
    if params.get("func_range", None) is not None:
        cargs.extend([
            "-func_range",
            str(params.get("func_range", None))
        ])
    if params.get("opacity", None) is not None:
        cargs.extend([
            "-opacity",
            str(params.get("opacity", None))
        ])
    if params.get("set_subbricks", None) is not None:
        cargs.extend([
            "-set_subbricks",
            params.get("set_subbricks", None)
        ])
    if params.get("montx", None) is not None:
        cargs.extend([
            "-montx",
            str(params.get("montx", None))
        ])
    if params.get("monty", None) is not None:
        cargs.extend([
            "-monty",
            str(params.get("monty", None))
        ])
    if params.get("montgap", None) is not None:
        cargs.extend([
            "-montgap",
            str(params.get("montgap", None))
        ])
    if params.get("label_mode", None) is not None:
        cargs.extend([
            "-label_mode",
            str(params.get("label_mode", None))
        ])
    if params.get("label_size", None) is not None:
        cargs.extend([
            "-label_size",
            str(params.get("label_size", None))
        ])
    if params.get("label_color", None) is not None:
        cargs.extend([
            "-label_color",
            params.get("label_color", None)
        ])
    if params.get("label_setback", None) is not None:
        cargs.extend([
            "-label_setback",
            str(params.get("label_setback", None))
        ])
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    if params.get("do_clean", False):
        cargs.append("-do_clean")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("version", False):
        cargs.append("-ver")
    return cargs


def v__chauffeur_afni_outputs(
    params: VChauffeurAfniParameters,
    execution: Execution,
) -> VChauffeurAfniOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VChauffeurAfniOutputs(
        root=execution.output_file("."),
        output_image=execution.output_file(params.get("prefix", None) + ".png"),
        cluster_report=execution.output_file(params.get("prefix", None) + "_clust_rep.txt"),
        whereami_report=execution.output_file(params.get("prefix", None) + "_clust_whereami.txt"),
    )
    return ret


def v__chauffeur_afni_execute(
    params: VChauffeurAfniParameters,
    runner: Runner | None = None,
) -> VChauffeurAfniOutputs:
    """
    @chauffeur_afni
    
    Automated QC snapshots generator in AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VChauffeurAfniOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__CHAUFFEUR_AFNI_METADATA)
    params = execution.params(params)
    cargs = v__chauffeur_afni_cargs(params, execution)
    ret = v__chauffeur_afni_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__chauffeur_afni(
    ulay: InputPathType,
    prefix: str,
    olay: InputPathType | None = None,
    mode_4_d: bool = False,
    func_range: float | None = None,
    opacity: float | None = None,
    set_subbricks: str | None = None,
    montx: float | None = None,
    monty: float | None = None,
    montgap: float | None = None,
    label_mode: float | None = None,
    label_size: float | None = None,
    label_color: str | None = None,
    label_setback: float | None = None,
    no_clean: bool = False,
    do_clean: bool = False,
    help_: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> VChauffeurAfniOutputs:
    """
    @chauffeur_afni
    
    Automated QC snapshots generator in AFNI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        ulay: Name of underlay dataset (required); can be 3D or 4D set.
        prefix: Prefix for output files (required).
        olay: Name of overlay dataset (optional).
        mode_4_d: For each viewing plane, one slice is selected across all\
            volumes in a 4D dataset.
        func_range: Specify upper value of the overlay dataset to be matched to\
            top of colorbar (default: 98%ile non-zero value of dataset).
        opacity: Enter an opacity factor for the overlay (0-9, with 9 being\
            opaque).
        set_subbricks: Specify subbricks for 3D image viewing.
        montx: Number of image panels in a row (default: 3).
        monty: Number of image panels in a column (default: 3).
        montgap: Number of pixels as gap between image panels (default: 0).
        label_mode: Control labels, ON/OFF and location (default: 1).
        label_size: Control labels, size (default: 3).
        label_color: Control labels, color (default: white).
        label_setback: Control labels, offset from edge (default: 0.01).
        no_clean: Do not remove the temporary directory of copied/intermediate\
            files.
        do_clean: Remove the temporary directory of copied/intermediate files.
        help_: Display help information.
        version: Display version number.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VChauffeurAfniOutputs`).
    """
    params = v__chauffeur_afni_params(
        ulay=ulay,
        olay=olay,
        prefix=prefix,
        mode_4_d=mode_4_d,
        func_range=func_range,
        opacity=opacity,
        set_subbricks=set_subbricks,
        montx=montx,
        monty=monty,
        montgap=montgap,
        label_mode=label_mode,
        label_size=label_size,
        label_color=label_color,
        label_setback=label_setback,
        no_clean=no_clean,
        do_clean=do_clean,
        help_=help_,
        version=version,
    )
    return v__chauffeur_afni_execute(params, runner)


__all__ = [
    "VChauffeurAfniOutputs",
    "V__CHAUFFEUR_AFNI_METADATA",
    "v__chauffeur_afni",
    "v__chauffeur_afni_execute",
    "v__chauffeur_afni_params",
]
