# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__CHECK_FOR_AFNI_DSET_METADATA = Metadata(
    id="ff6f4cebbc73c5968164aafe5e717c47545f280a.boutiques",
    name="@CheckForAfniDset",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VCheckForAfniDsetParameters = typing.TypedDict('VCheckForAfniDsetParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@CheckForAfniDset"]],
    "dataset_name": str,
})
VCheckForAfniDsetParametersTagged = typing.TypedDict('VCheckForAfniDsetParametersTagged', {
    "@type": typing.Literal["afni/@CheckForAfniDset"],
    "dataset_name": str,
})


class VCheckForAfniDsetOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VCheckForAfniDsetParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_status: OutputPathType
    """Text file containing the status code of the dataset"""


def v__check_for_afni_dset_params(
    dataset_name: str,
) -> VCheckForAfniDsetParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset_name: Path to the AFNI dataset (e.g.,\
            /Data/stuff/Hello+orig.HEAD).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@CheckForAfniDset",
        "dataset_name": dataset_name,
    }
    return params


def v__check_for_afni_dset_cargs(
    params: VCheckForAfniDsetParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@CheckForAfniDset")
    cargs.append(params.get("dataset_name", None))
    return cargs


def v__check_for_afni_dset_outputs(
    params: VCheckForAfniDsetParameters,
    execution: Execution,
) -> VCheckForAfniDsetOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VCheckForAfniDsetOutputs(
        root=execution.output_file("."),
        output_status=execution.output_file(params.get("dataset_name", None) + "_status.txt"),
    )
    return ret


def v__check_for_afni_dset_execute(
    params: VCheckForAfniDsetParameters,
    runner: Runner | None = None,
) -> VCheckForAfniDsetOutputs:
    """
    @CheckForAfniDset
    
    Check for the existence of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VCheckForAfniDsetOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__CHECK_FOR_AFNI_DSET_METADATA)
    params = execution.params(params)
    cargs = v__check_for_afni_dset_cargs(params, execution)
    ret = v__check_for_afni_dset_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__check_for_afni_dset(
    dataset_name: str,
    runner: Runner | None = None,
) -> VCheckForAfniDsetOutputs:
    """
    @CheckForAfniDset
    
    Check for the existence of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset_name: Path to the AFNI dataset (e.g.,\
            /Data/stuff/Hello+orig.HEAD).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VCheckForAfniDsetOutputs`).
    """
    params = v__check_for_afni_dset_params(
        dataset_name=dataset_name,
    )
    return v__check_for_afni_dset_execute(params, runner)


__all__ = [
    "VCheckForAfniDsetOutputs",
    "V__CHECK_FOR_AFNI_DSET_METADATA",
    "v__check_for_afni_dset",
    "v__check_for_afni_dset_execute",
    "v__check_for_afni_dset_params",
]
