# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__COMPUTE_GCOR_METADATA = Metadata(
    id="ff28d4939bf8b46e877006f649680caefff5f639.boutiques",
    name="@compute_gcor",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VComputeGcorParameters = typing.TypedDict('VComputeGcorParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@compute_gcor"]],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "corr_vol_prefix": typing.NotRequired[str | None],
    "initial_trs": typing.NotRequired[float | None],
    "no_demean": bool,
    "save_tmp": bool,
    "verbose": typing.NotRequired[float | None],
})
VComputeGcorParametersTagged = typing.TypedDict('VComputeGcorParametersTagged', {
    "@type": typing.Literal["afni/@compute_gcor"],
    "input": InputPathType,
    "mask": typing.NotRequired[InputPathType | None],
    "corr_vol_prefix": typing.NotRequired[str | None],
    "initial_trs": typing.NotRequired[float | None],
    "no_demean": bool,
    "save_tmp": bool,
    "verbose": typing.NotRequired[float | None],
})


class VComputeGcorOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VComputeGcorParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    corr_vol_brik: OutputPathType | None
    """Output correlation volume BRIK file"""
    corr_vol_head: OutputPathType | None
    """Output correlation volume HEAD file"""


def v__compute_gcor_params(
    input_: InputPathType,
    mask: InputPathType | None = None,
    corr_vol_prefix: str | None = None,
    initial_trs: float | None = None,
    no_demean: bool = False,
    save_tmp: bool = False,
    verbose: float | None = None,
) -> VComputeGcorParametersTagged:
    """
    Build parameters.
    
    Args:
        input_: Specify input dataset to compute the GCOR over.
        mask: Specify mask dataset, for restricting the computation.
        corr_vol_prefix: Specify prefix for correlation volume output.
        initial_trs: Specify number of initial TRs to ignore.
        no_demean: Do not demean as the first step.
        save_tmp: Save temporary files (do not remove at end).
        verbose: Set verbose level (0=quiet, 3=max).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@compute_gcor",
        "input": input_,
        "no_demean": no_demean,
        "save_tmp": save_tmp,
    }
    if mask is not None:
        params["mask"] = mask
    if corr_vol_prefix is not None:
        params["corr_vol_prefix"] = corr_vol_prefix
    if initial_trs is not None:
        params["initial_trs"] = initial_trs
    if verbose is not None:
        params["verbose"] = verbose
    return params


def v__compute_gcor_cargs(
    params: VComputeGcorParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@compute_gcor")
    cargs.append(execution.input_file(params.get("input", None)))
    if params.get("mask", None) is not None:
        cargs.append(execution.input_file(params.get("mask", None)))
    if params.get("corr_vol_prefix", None) is not None:
        cargs.extend([
            "-corr_vol",
            params.get("corr_vol_prefix", None)
        ])
    if params.get("initial_trs", None) is not None:
        cargs.extend([
            "-nfirst",
            str(params.get("initial_trs", None))
        ])
    if params.get("no_demean", False):
        cargs.append("-no_demean")
    if params.get("save_tmp", False):
        cargs.append("-savetmp")
    if params.get("verbose", None) is not None:
        cargs.extend([
            "-verb",
            str(params.get("verbose", None))
        ])
    return cargs


def v__compute_gcor_outputs(
    params: VComputeGcorParameters,
    execution: Execution,
) -> VComputeGcorOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VComputeGcorOutputs(
        root=execution.output_file("."),
        corr_vol_brik=execution.output_file(params.get("corr_vol_prefix", None) + "+tlrc.BRIK") if (params.get("corr_vol_prefix") is not None) else None,
        corr_vol_head=execution.output_file(params.get("corr_vol_prefix", None) + "+tlrc.HEAD") if (params.get("corr_vol_prefix") is not None) else None,
    )
    return ret


def v__compute_gcor_execute(
    params: VComputeGcorParameters,
    runner: Runner | None = None,
) -> VComputeGcorOutputs:
    """
    @compute_gcor
    
    Compute GCOR, the global correlation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VComputeGcorOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__COMPUTE_GCOR_METADATA)
    params = execution.params(params)
    cargs = v__compute_gcor_cargs(params, execution)
    ret = v__compute_gcor_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__compute_gcor(
    input_: InputPathType,
    mask: InputPathType | None = None,
    corr_vol_prefix: str | None = None,
    initial_trs: float | None = None,
    no_demean: bool = False,
    save_tmp: bool = False,
    verbose: float | None = None,
    runner: Runner | None = None,
) -> VComputeGcorOutputs:
    """
    @compute_gcor
    
    Compute GCOR, the global correlation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_: Specify input dataset to compute the GCOR over.
        mask: Specify mask dataset, for restricting the computation.
        corr_vol_prefix: Specify prefix for correlation volume output.
        initial_trs: Specify number of initial TRs to ignore.
        no_demean: Do not demean as the first step.
        save_tmp: Save temporary files (do not remove at end).
        verbose: Set verbose level (0=quiet, 3=max).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VComputeGcorOutputs`).
    """
    params = v__compute_gcor_params(
        input_=input_,
        mask=mask,
        corr_vol_prefix=corr_vol_prefix,
        initial_trs=initial_trs,
        no_demean=no_demean,
        save_tmp=save_tmp,
        verbose=verbose,
    )
    return v__compute_gcor_execute(params, runner)


__all__ = [
    "VComputeGcorOutputs",
    "V__COMPUTE_GCOR_METADATA",
    "v__compute_gcor",
    "v__compute_gcor_execute",
    "v__compute_gcor_params",
]
