# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DEMO_PROMPT_METADATA = Metadata(
    id="4251e0d6491e307ef7755ae3aaf712a6534ad2f2.boutiques",
    name="@demo_prompt",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDemoPromptParameters = typing.TypedDict('VDemoPromptParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@demo_prompt"]],
    "message": str,
})
VDemoPromptParametersTagged = typing.TypedDict('VDemoPromptParametersTagged', {
    "@type": typing.Literal["afni/@demo_prompt"],
    "message": str,
})


class VDemoPromptOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDemoPromptParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    status: OutputPathType
    """Status output: 0 if user presses OK, 1 if user cancels"""


def v__demo_prompt_params(
    message: str,
) -> VDemoPromptParametersTagged:
    """
    Build parameters.
    
    Args:
        message: The message to display in the prompt.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@demo_prompt",
        "message": message,
    }
    return params


def v__demo_prompt_cargs(
    params: VDemoPromptParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@demo_prompt")
    cargs.append(params.get("message", None))
    return cargs


def v__demo_prompt_outputs(
    params: VDemoPromptParameters,
    execution: Execution,
) -> VDemoPromptOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDemoPromptOutputs(
        root=execution.output_file("."),
        status=execution.output_file("status"),
    )
    return ret


def v__demo_prompt_execute(
    params: VDemoPromptParameters,
    runner: Runner | None = None,
) -> VDemoPromptOutputs:
    """
    @demo_prompt
    
    Prompts user with a message and waits for acknowledgment.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDemoPromptOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DEMO_PROMPT_METADATA)
    params = execution.params(params)
    cargs = v__demo_prompt_cargs(params, execution)
    ret = v__demo_prompt_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__demo_prompt(
    message: str,
    runner: Runner | None = None,
) -> VDemoPromptOutputs:
    """
    @demo_prompt
    
    Prompts user with a message and waits for acknowledgment.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        message: The message to display in the prompt.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDemoPromptOutputs`).
    """
    params = v__demo_prompt_params(
        message=message,
    )
    return v__demo_prompt_execute(params, runner)


__all__ = [
    "VDemoPromptOutputs",
    "V__DEMO_PROMPT_METADATA",
    "v__demo_prompt",
    "v__demo_prompt_execute",
    "v__demo_prompt_params",
]
