# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DJUNCT_4D_IMAGER_METADATA = Metadata(
    id="08addc99f8ae636c5a8b49cdb8cbebf6b46e71ae.boutiques",
    name="@djunct_4d_imager",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDjunct4dImagerParameters = typing.TypedDict('VDjunct4dImagerParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@djunct_4d_imager"]],
    "inset": InputPathType,
    "prefix": str,
    "do_movie": typing.NotRequired[typing.Literal["MPEG", "AGIF"] | None],
    "no_clean": bool,
})
VDjunct4dImagerParametersTagged = typing.TypedDict('VDjunct4dImagerParametersTagged', {
    "@type": typing.Literal["afni/@djunct_4d_imager"],
    "inset": InputPathType,
    "prefix": str,
    "do_movie": typing.NotRequired[typing.Literal["MPEG", "AGIF"] | None],
    "no_clean": bool,
})


class VDjunct4dImagerOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDjunct4dImagerParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    onescl_png: OutputPathType
    """Output montage image with constant brightness range"""
    sepscl_png: OutputPathType
    """Output montage image with varying brightness range"""
    onescl_mpeg: OutputPathType
    """Output movie with constant brightness range (one slice at a time)"""
    sepscl_mpeg: OutputPathType
    """Output movie with varying brightness range (one slice at a time)"""
    onescl_gif: OutputPathType
    """Output animated GIF with constant brightness range (one slice at a
    time)"""
    sepscl_gif: OutputPathType
    """Output animated GIF with varying brightness range (one slice at a
    time)"""


def v__djunct_4d_imager_params(
    inset: InputPathType,
    prefix: str,
    do_movie: typing.Literal["MPEG", "AGIF"] | None = None,
    no_clean: bool = False,
) -> VDjunct4dImagerParametersTagged:
    """
    Build parameters.
    
    Args:
        inset: ULay dataset, probably 4D (required).
        prefix: Prefix for output files (required).
        do_movie: Specify type of movie file. Options: MPEG, AGIF.
        no_clean: Keep the final intermediate files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@djunct_4d_imager",
        "inset": inset,
        "prefix": prefix,
        "no_clean": no_clean,
    }
    if do_movie is not None:
        params["do_movie"] = do_movie
    return params


def v__djunct_4d_imager_cargs(
    params: VDjunct4dImagerParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@djunct_4d_imager")
    cargs.append(execution.input_file(params.get("inset", None)))
    cargs.append(params.get("prefix", None))
    if params.get("do_movie", None) is not None:
        cargs.extend([
            "-do_movie",
            params.get("do_movie", None)
        ])
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    return cargs


def v__djunct_4d_imager_outputs(
    params: VDjunct4dImagerParameters,
    execution: Execution,
) -> VDjunct4dImagerOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDjunct4dImagerOutputs(
        root=execution.output_file("."),
        onescl_png=execution.output_file(params.get("prefix", None) + "_onescl.png"),
        sepscl_png=execution.output_file(params.get("prefix", None) + "_sepscl.png"),
        onescl_mpeg=execution.output_file(params.get("prefix", None) + "_onescl.mpg"),
        sepscl_mpeg=execution.output_file(params.get("prefix", None) + "_sepscl.mpg"),
        onescl_gif=execution.output_file(params.get("prefix", None) + "_onescl.gif"),
        sepscl_gif=execution.output_file(params.get("prefix", None) + "_sepscl.gif"),
    )
    return ret


def v__djunct_4d_imager_execute(
    params: VDjunct4dImagerParameters,
    runner: Runner | None = None,
) -> VDjunct4dImagerOutputs:
    """
    @djunct_4d_imager
    
    The program is useful for viewing the same slice across the 'time' dimension
    of a 4D data set.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunct4dImagerOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DJUNCT_4D_IMAGER_METADATA)
    params = execution.params(params)
    cargs = v__djunct_4d_imager_cargs(params, execution)
    ret = v__djunct_4d_imager_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__djunct_4d_imager(
    inset: InputPathType,
    prefix: str,
    do_movie: typing.Literal["MPEG", "AGIF"] | None = None,
    no_clean: bool = False,
    runner: Runner | None = None,
) -> VDjunct4dImagerOutputs:
    """
    @djunct_4d_imager
    
    The program is useful for viewing the same slice across the 'time' dimension
    of a 4D data set.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inset: ULay dataset, probably 4D (required).
        prefix: Prefix for output files (required).
        do_movie: Specify type of movie file. Options: MPEG, AGIF.
        no_clean: Keep the final intermediate files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunct4dImagerOutputs`).
    """
    params = v__djunct_4d_imager_params(
        inset=inset,
        prefix=prefix,
        do_movie=do_movie,
        no_clean=no_clean,
    )
    return v__djunct_4d_imager_execute(params, runner)


__all__ = [
    "VDjunct4dImagerOutputs",
    "V__DJUNCT_4D_IMAGER_METADATA",
    "v__djunct_4d_imager",
    "v__djunct_4d_imager_execute",
    "v__djunct_4d_imager_params",
]
