# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DJUNCT_DWI_SELECTOR_TCSH_METADATA = Metadata(
    id="109039a88bf5d11d8ade6641a42d55a055de6525.boutiques",
    name="@djunct_dwi_selector.tcsh",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDjunctDwiSelectorTcshParameters = typing.TypedDict('VDjunctDwiSelectorTcshParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@djunct_dwi_selector.tcsh"]],
    "dwi": InputPathType,
    "png": InputPathType,
    "outfile": str,
})
VDjunctDwiSelectorTcshParametersTagged = typing.TypedDict('VDjunctDwiSelectorTcshParametersTagged', {
    "@type": typing.Literal["afni/@djunct_dwi_selector.tcsh"],
    "dwi": InputPathType,
    "png": InputPathType,
    "outfile": str,
})


class VDjunctDwiSelectorTcshOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDjunctDwiSelectorTcshParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """The main output file"""


def v__djunct_dwi_selector_tcsh_params(
    dwi: InputPathType,
    png: InputPathType,
    outfile: str,
) -> VDjunctDwiSelectorTcshParametersTagged:
    """
    Build parameters.
    
    Args:
        dwi: Input DWI file.
        png: Output PNG image.
        outfile: Path to the output file.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@djunct_dwi_selector.tcsh",
        "dwi": dwi,
        "png": png,
        "outfile": outfile,
    }
    return params


def v__djunct_dwi_selector_tcsh_cargs(
    params: VDjunctDwiSelectorTcshParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@djunct_dwi_selector.tcsh")
    cargs.append(execution.input_file(params.get("dwi", None)))
    cargs.append(execution.input_file(params.get("png", None)))
    cargs.append(params.get("outfile", None))
    return cargs


def v__djunct_dwi_selector_tcsh_outputs(
    params: VDjunctDwiSelectorTcshParameters,
    execution: Execution,
) -> VDjunctDwiSelectorTcshOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDjunctDwiSelectorTcshOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file(params.get("outfile", None)),
    )
    return ret


def v__djunct_dwi_selector_tcsh_execute(
    params: VDjunctDwiSelectorTcshParameters,
    runner: Runner | None = None,
) -> VDjunctDwiSelectorTcshOutputs:
    """
    @djunct_dwi_selector.tcsh
    
    Selects DWI data and creates a representative image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctDwiSelectorTcshOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DJUNCT_DWI_SELECTOR_TCSH_METADATA)
    params = execution.params(params)
    cargs = v__djunct_dwi_selector_tcsh_cargs(params, execution)
    ret = v__djunct_dwi_selector_tcsh_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__djunct_dwi_selector_tcsh(
    dwi: InputPathType,
    png: InputPathType,
    outfile: str,
    runner: Runner | None = None,
) -> VDjunctDwiSelectorTcshOutputs:
    """
    @djunct_dwi_selector.tcsh
    
    Selects DWI data and creates a representative image.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dwi: Input DWI file.
        png: Output PNG image.
        outfile: Path to the output file.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctDwiSelectorTcshOutputs`).
    """
    params = v__djunct_dwi_selector_tcsh_params(
        dwi=dwi,
        png=png,
        outfile=outfile,
    )
    return v__djunct_dwi_selector_tcsh_execute(params, runner)


__all__ = [
    "VDjunctDwiSelectorTcshOutputs",
    "V__DJUNCT_DWI_SELECTOR_TCSH_METADATA",
    "v__djunct_dwi_selector_tcsh",
    "v__djunct_dwi_selector_tcsh_execute",
    "v__djunct_dwi_selector_tcsh_params",
]
