# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DJUNCT_MONTAGE_COORDINATOR_METADATA = Metadata(
    id="543baf357b03cf37f54ec8393a57595187a3d63b.boutiques",
    name="@djunct_montage_coordinator",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDjunctMontageCoordinatorParameters = typing.TypedDict('VDjunctMontageCoordinatorParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@djunct_montage_coordinator"]],
    "input_file": InputPathType,
    "montx": float,
    "monty": float,
    "out_ijk": bool,
    "out_xyz": bool,
    "help": bool,
    "version": bool,
})
VDjunctMontageCoordinatorParametersTagged = typing.TypedDict('VDjunctMontageCoordinatorParametersTagged', {
    "@type": typing.Literal["afni/@djunct_montage_coordinator"],
    "input_file": InputPathType,
    "montx": float,
    "monty": float,
    "out_ijk": bool,
    "out_xyz": bool,
    "help": bool,
    "version": bool,
})


class VDjunctMontageCoordinatorOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDjunctMontageCoordinatorParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_coords: OutputPathType
    """Output coordinates (IJK or XYZ) for the montage setup."""


def v__djunct_montage_coordinator_params(
    input_file: InputPathType,
    montx: float,
    monty: float,
    out_ijk: bool = False,
    out_xyz: bool = False,
    help_: bool = False,
    version: bool = False,
) -> VDjunctMontageCoordinatorParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Name of input dataset.
        montx: Montage dimension: number of panels along x-axis (i.e., number\
            of cols).
        monty: Montage dimension: number of panels along y-axis (i.e., number\
            of rows).
        out_ijk: Make program output 'I J K' values.
        out_xyz: Make program output 'X Y Z' values.
        help_: See helpfile.
        version: See version number.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@djunct_montage_coordinator",
        "input_file": input_file,
        "montx": montx,
        "monty": monty,
        "out_ijk": out_ijk,
        "out_xyz": out_xyz,
        "help": help_,
        "version": version,
    }
    return params


def v__djunct_montage_coordinator_cargs(
    params: VDjunctMontageCoordinatorParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@djunct_montage_coordinator")
    cargs.extend([
        "-inset",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-montx",
        str(params.get("montx", None))
    ])
    cargs.extend([
        "-monty",
        str(params.get("monty", None))
    ])
    if params.get("out_ijk", False):
        cargs.append("-out_ijk")
    if params.get("out_xyz", False):
        cargs.append("-out_xyz")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("version", False):
        cargs.append("-ver")
    return cargs


def v__djunct_montage_coordinator_outputs(
    params: VDjunctMontageCoordinatorParameters,
    execution: Execution,
) -> VDjunctMontageCoordinatorOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDjunctMontageCoordinatorOutputs(
        root=execution.output_file("."),
        output_coords=execution.output_file("output.txt"),
    )
    return ret


def v__djunct_montage_coordinator_execute(
    params: VDjunctMontageCoordinatorParameters,
    runner: Runner | None = None,
) -> VDjunctMontageCoordinatorOutputs:
    """
    @djunct_montage_coordinator
    
    Small program to calculate how to evenly space a certain number of slices
    within each view plane of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctMontageCoordinatorOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DJUNCT_MONTAGE_COORDINATOR_METADATA)
    params = execution.params(params)
    cargs = v__djunct_montage_coordinator_cargs(params, execution)
    ret = v__djunct_montage_coordinator_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__djunct_montage_coordinator(
    input_file: InputPathType,
    montx: float,
    monty: float,
    out_ijk: bool = False,
    out_xyz: bool = False,
    help_: bool = False,
    version: bool = False,
    runner: Runner | None = None,
) -> VDjunctMontageCoordinatorOutputs:
    """
    @djunct_montage_coordinator
    
    Small program to calculate how to evenly space a certain number of slices
    within each view plane of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Name of input dataset.
        montx: Montage dimension: number of panels along x-axis (i.e., number\
            of cols).
        monty: Montage dimension: number of panels along y-axis (i.e., number\
            of rows).
        out_ijk: Make program output 'I J K' values.
        out_xyz: Make program output 'X Y Z' values.
        help_: See helpfile.
        version: See version number.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctMontageCoordinatorOutputs`).
    """
    params = v__djunct_montage_coordinator_params(
        input_file=input_file,
        montx=montx,
        monty=monty,
        out_ijk=out_ijk,
        out_xyz=out_xyz,
        help_=help_,
        version=version,
    )
    return v__djunct_montage_coordinator_execute(params, runner)


__all__ = [
    "VDjunctMontageCoordinatorOutputs",
    "V__DJUNCT_MONTAGE_COORDINATOR_METADATA",
    "v__djunct_montage_coordinator",
    "v__djunct_montage_coordinator_execute",
    "v__djunct_montage_coordinator_params",
]
