# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DJUNCT_SSW_INTERMED_EDGE_IMGS_METADATA = Metadata(
    id="73d44565de02bb65620475a843396d62b14f4d35.boutiques",
    name="@djunct_ssw_intermed_edge_imgs",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDjunctSswIntermedEdgeImgsParameters = typing.TypedDict('VDjunctSswIntermedEdgeImgsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@djunct_ssw_intermed_edge_imgs"]],
    "prefix": str,
    "ulay": InputPathType,
    "olay": InputPathType,
    "box_focus_slices": typing.NotRequired[str | None],
    "montgap": typing.NotRequired[str | None],
    "cbar": typing.NotRequired[str | None],
    "ulay_range": typing.NotRequired[str | None],
    "montx": typing.NotRequired[str | None],
    "monty": typing.NotRequired[str | None],
    "help_view": bool,
    "help": bool,
    "version": bool,
    "no_clean": bool,
})
VDjunctSswIntermedEdgeImgsParametersTagged = typing.TypedDict('VDjunctSswIntermedEdgeImgsParametersTagged', {
    "@type": typing.Literal["afni/@djunct_ssw_intermed_edge_imgs"],
    "prefix": str,
    "ulay": InputPathType,
    "olay": InputPathType,
    "box_focus_slices": typing.NotRequired[str | None],
    "montgap": typing.NotRequired[str | None],
    "cbar": typing.NotRequired[str | None],
    "ulay_range": typing.NotRequired[str | None],
    "montx": typing.NotRequired[str | None],
    "monty": typing.NotRequired[str | None],
    "help_view": bool,
    "help": bool,
    "version": bool,
    "no_clean": bool,
})


class VDjunctSswIntermedEdgeImgsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDjunctSswIntermedEdgeImgsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__djunct_ssw_intermed_edge_imgs_params(
    prefix: str,
    ulay: InputPathType,
    olay: InputPathType,
    box_focus_slices: str | None = None,
    montgap: str | None = None,
    cbar: str | None = None,
    ulay_range: str | None = None,
    montx: str | None = None,
    monty: str | None = None,
    help_view: bool = False,
    help_: bool = False,
    version: bool = False,
    no_clean: bool = False,
) -> VDjunctSswIntermedEdgeImgsParametersTagged:
    """
    Build parameters.
    
    Args:
        prefix: Prefix for generated output files.
        ulay: Underlay dataset.
        olay: Overlay dataset.
        box_focus_slices: Slices of interest for focus box.
        montgap: Gap between montage slices.
        cbar: Color bar specification for AFNI.
        ulay_range: Range for underlay data mapping.
        montx: Number of slices along x dimension in montage.
        monty: Number of slices along y dimension in montage.
        help_view: View help file in viewer.
        help_: Displays help information.
        version: Displays version information.
        no_clean: Don't clean up intermediate files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@djunct_ssw_intermed_edge_imgs",
        "prefix": prefix,
        "ulay": ulay,
        "olay": olay,
        "help_view": help_view,
        "help": help_,
        "version": version,
        "no_clean": no_clean,
    }
    if box_focus_slices is not None:
        params["box_focus_slices"] = box_focus_slices
    if montgap is not None:
        params["montgap"] = montgap
    if cbar is not None:
        params["cbar"] = cbar
    if ulay_range is not None:
        params["ulay_range"] = ulay_range
    if montx is not None:
        params["montx"] = montx
    if monty is not None:
        params["monty"] = monty
    return params


def v__djunct_ssw_intermed_edge_imgs_cargs(
    params: VDjunctSswIntermedEdgeImgsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@djunct_ssw_intermed_edge_imgs")
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    cargs.extend([
        "-ulay",
        execution.input_file(params.get("ulay", None))
    ])
    cargs.extend([
        "-olay",
        execution.input_file(params.get("olay", None))
    ])
    if params.get("box_focus_slices", None) is not None:
        cargs.extend([
            "-box_focus_slices",
            params.get("box_focus_slices", None)
        ])
    if params.get("montgap", None) is not None:
        cargs.extend([
            "-montgap",
            params.get("montgap", None)
        ])
    if params.get("cbar", None) is not None:
        cargs.extend([
            "-cbar",
            params.get("cbar", None)
        ])
    if params.get("ulay_range", None) is not None:
        cargs.extend([
            "-ulay_range",
            params.get("ulay_range", None)
        ])
    if params.get("montx", None) is not None:
        cargs.extend([
            "-montx",
            params.get("montx", None)
        ])
    if params.get("monty", None) is not None:
        cargs.extend([
            "-monty",
            params.get("monty", None)
        ])
    if params.get("help_view", False):
        cargs.append("-hview")
    if params.get("help", False):
        cargs.append("-help")
    if params.get("version", False):
        cargs.append("-ver")
    if params.get("no_clean", False):
        cargs.append("-no_clean")
    return cargs


def v__djunct_ssw_intermed_edge_imgs_outputs(
    params: VDjunctSswIntermedEdgeImgsParameters,
    execution: Execution,
) -> VDjunctSswIntermedEdgeImgsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDjunctSswIntermedEdgeImgsOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__djunct_ssw_intermed_edge_imgs_execute(
    params: VDjunctSswIntermedEdgeImgsParameters,
    runner: Runner | None = None,
) -> VDjunctSswIntermedEdgeImgsOutputs:
    """
    @djunct_ssw_intermed_edge_imgs
    
    Helper script to generate intermediate edge images for SSW-related
    processing.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctSswIntermedEdgeImgsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DJUNCT_SSW_INTERMED_EDGE_IMGS_METADATA)
    params = execution.params(params)
    cargs = v__djunct_ssw_intermed_edge_imgs_cargs(params, execution)
    ret = v__djunct_ssw_intermed_edge_imgs_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__djunct_ssw_intermed_edge_imgs(
    prefix: str,
    ulay: InputPathType,
    olay: InputPathType,
    box_focus_slices: str | None = None,
    montgap: str | None = None,
    cbar: str | None = None,
    ulay_range: str | None = None,
    montx: str | None = None,
    monty: str | None = None,
    help_view: bool = False,
    help_: bool = False,
    version: bool = False,
    no_clean: bool = False,
    runner: Runner | None = None,
) -> VDjunctSswIntermedEdgeImgsOutputs:
    """
    @djunct_ssw_intermed_edge_imgs
    
    Helper script to generate intermediate edge images for SSW-related
    processing.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        prefix: Prefix for generated output files.
        ulay: Underlay dataset.
        olay: Overlay dataset.
        box_focus_slices: Slices of interest for focus box.
        montgap: Gap between montage slices.
        cbar: Color bar specification for AFNI.
        ulay_range: Range for underlay data mapping.
        montx: Number of slices along x dimension in montage.
        monty: Number of slices along y dimension in montage.
        help_view: View help file in viewer.
        help_: Displays help information.
        version: Displays version information.
        no_clean: Don't clean up intermediate files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDjunctSswIntermedEdgeImgsOutputs`).
    """
    params = v__djunct_ssw_intermed_edge_imgs_params(
        prefix=prefix,
        ulay=ulay,
        olay=olay,
        box_focus_slices=box_focus_slices,
        montgap=montgap,
        cbar=cbar,
        ulay_range=ulay_range,
        montx=montx,
        monty=monty,
        help_view=help_view,
        help_=help_,
        version=version,
        no_clean=no_clean,
    )
    return v__djunct_ssw_intermed_edge_imgs_execute(params, runner)


__all__ = [
    "VDjunctSswIntermedEdgeImgsOutputs",
    "V__DJUNCT_SSW_INTERMED_EDGE_IMGS_METADATA",
    "v__djunct_ssw_intermed_edge_imgs",
    "v__djunct_ssw_intermed_edge_imgs_execute",
    "v__djunct_ssw_intermed_edge_imgs_params",
]
