# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__DO_EXAMPLES_METADATA = Metadata(
    id="47272bd0f3dfa19e13c057cdd5402823540cb26b.boutiques",
    name="@DO.examples",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VDoExamplesParameters = typing.TypedDict('VDoExamplesParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@DO.examples"]],
    "auto_test": bool,
})
VDoExamplesParametersTagged = typing.TypedDict('VDoExamplesParametersTagged', {
    "@type": typing.Literal["afni/@DO.examples"],
    "auto_test": bool,
})


class VDoExamplesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VDoExamplesParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_log: OutputPathType
    """Output log file when running in auto test mode"""


def v__do_examples_params(
    auto_test: bool = False,
) -> VDoExamplesParametersTagged:
    """
    Build parameters.
    
    Args:
        auto_test: Run this script in test mode where user prompts are timed\
            out at 2 seconds, and the command output log is preserved in a file\
            called __testlog.txt.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@DO.examples",
        "auto_test": auto_test,
    }
    return params


def v__do_examples_cargs(
    params: VDoExamplesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@DO.examples")
    if params.get("auto_test", False):
        cargs.append("-auto_test")
    return cargs


def v__do_examples_outputs(
    params: VDoExamplesParameters,
    execution: Execution,
) -> VDoExamplesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VDoExamplesOutputs(
        root=execution.output_file("."),
        output_log=execution.output_file("__testlog.txt"),
    )
    return ret


def v__do_examples_execute(
    params: VDoExamplesParameters,
    runner: Runner | None = None,
) -> VDoExamplesOutputs:
    """
    @DO.examples
    
    A script to illustrate the use of Displayable Objects in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDoExamplesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__DO_EXAMPLES_METADATA)
    params = execution.params(params)
    cargs = v__do_examples_cargs(params, execution)
    ret = v__do_examples_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__do_examples(
    auto_test: bool = False,
    runner: Runner | None = None,
) -> VDoExamplesOutputs:
    """
    @DO.examples
    
    A script to illustrate the use of Displayable Objects in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        auto_test: Run this script in test mode where user prompts are timed\
            out at 2 seconds, and the command output log is preserved in a file\
            called __testlog.txt.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VDoExamplesOutputs`).
    """
    params = v__do_examples_params(
        auto_test=auto_test,
    )
    return v__do_examples_execute(params, runner)


__all__ = [
    "VDoExamplesOutputs",
    "V__DO_EXAMPLES_METADATA",
    "v__do_examples",
    "v__do_examples_execute",
    "v__do_examples_params",
]
