# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__ELECTRO_GRID_METADATA = Metadata(
    id="8ac7f5045194e5e0a61feb132b6f3dfdbb4abcc2.boutiques",
    name="@ElectroGrid",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VElectroGridParameters = typing.TypedDict('VElectroGridParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@ElectroGrid"]],
    "strip": typing.NotRequired[int | None],
    "grid": typing.NotRequired[list[int] | None],
    "prefix": typing.NotRequired[str | None],
    "coords": typing.NotRequired[InputPathType | None],
    "with_markers": bool,
    "echo": bool,
})
VElectroGridParametersTagged = typing.TypedDict('VElectroGridParametersTagged', {
    "@type": typing.Literal["afni/@ElectroGrid"],
    "strip": typing.NotRequired[int | None],
    "grid": typing.NotRequired[list[int] | None],
    "prefix": typing.NotRequired[str | None],
    "coords": typing.NotRequired[InputPathType | None],
    "with_markers": bool,
    "echo": bool,
})


class VElectroGridOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VElectroGridParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_surface: OutputPathType | None
    """Output surface file"""


def v__electro_grid_params(
    strip: int | None = None,
    grid: list[int] | None = None,
    prefix: str | None = None,
    coords: InputPathType | None = None,
    with_markers: bool = False,
    echo: bool = False,
) -> VElectroGridParametersTagged:
    """
    Build parameters.
    
    Args:
        strip: Make an Nx strip (array) of electrodes.
        grid: Make an Nx by Ny grid of electrodes. A node at (i,j) has a node\
            ID = i+Nx*j with 0<=i<Nx and 0<=j<=Ny.
        prefix: Use PREFIX for the output surface.
        coords: Specify the coordinates of the nodes on the grid, or the array.\
            XYZ.1D should have three columns, with each row specifying the\
            coordinates of one node.
        with_markers: Add markers to the surface at each electrode.
        echo: Set echo.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@ElectroGrid",
        "with_markers": with_markers,
        "echo": echo,
    }
    if strip is not None:
        params["strip"] = strip
    if grid is not None:
        params["grid"] = grid
    if prefix is not None:
        params["prefix"] = prefix
    if coords is not None:
        params["coords"] = coords
    return params


def v__electro_grid_cargs(
    params: VElectroGridParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@ElectroGrid")
    if params.get("strip", None) is not None:
        cargs.extend([
            "-strip",
            str(params.get("strip", None))
        ])
    if params.get("grid", None) is not None:
        cargs.extend([
            "-grid",
            *map(str, params.get("grid", None))
        ])
    if params.get("prefix", None) is not None:
        cargs.extend([
            "-prefix",
            params.get("prefix", None)
        ])
    if params.get("coords", None) is not None:
        cargs.extend([
            "-coords",
            execution.input_file(params.get("coords", None))
        ])
    if params.get("with_markers", False):
        cargs.append("-with_markers")
    if params.get("echo", False):
        cargs.append("-echo")
    return cargs


def v__electro_grid_outputs(
    params: VElectroGridParameters,
    execution: Execution,
) -> VElectroGridOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VElectroGridOutputs(
        root=execution.output_file("."),
        output_surface=execution.output_file(params.get("prefix", None) + ".gii") if (params.get("prefix") is not None) else None,
    )
    return ret


def v__electro_grid_execute(
    params: VElectroGridParameters,
    runner: Runner | None = None,
) -> VElectroGridOutputs:
    """
    @ElectroGrid
    
    Creates a mesh representation of an electrode grid for use with SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VElectroGridOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__ELECTRO_GRID_METADATA)
    params = execution.params(params)
    cargs = v__electro_grid_cargs(params, execution)
    ret = v__electro_grid_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__electro_grid(
    strip: int | None = None,
    grid: list[int] | None = None,
    prefix: str | None = None,
    coords: InputPathType | None = None,
    with_markers: bool = False,
    echo: bool = False,
    runner: Runner | None = None,
) -> VElectroGridOutputs:
    """
    @ElectroGrid
    
    Creates a mesh representation of an electrode grid for use with SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        strip: Make an Nx strip (array) of electrodes.
        grid: Make an Nx by Ny grid of electrodes. A node at (i,j) has a node\
            ID = i+Nx*j with 0<=i<Nx and 0<=j<=Ny.
        prefix: Use PREFIX for the output surface.
        coords: Specify the coordinates of the nodes on the grid, or the array.\
            XYZ.1D should have three columns, with each row specifying the\
            coordinates of one node.
        with_markers: Add markers to the surface at each electrode.
        echo: Set echo.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VElectroGridOutputs`).
    """
    params = v__electro_grid_params(
        strip=strip,
        grid=grid,
        prefix=prefix,
        coords=coords,
        with_markers=with_markers,
        echo=echo,
    )
    return v__electro_grid_execute(params, runner)


__all__ = [
    "VElectroGridOutputs",
    "V__ELECTRO_GRID_METADATA",
    "v__electro_grid",
    "v__electro_grid_execute",
    "v__electro_grid_params",
]
