# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__FAST_ROI_METADATA = Metadata(
    id="be9840e265ca2a4c3bef07aff8593f44a38ea15a.boutiques",
    name="@fast_roi",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VFastRoiParameters = typing.TypedDict('VFastRoiParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@fast_roi"]],
    "region": list[str],
    "drawn_roi": typing.NotRequired[InputPathType | None],
    "anat": InputPathType,
    "anat_ns": typing.NotRequired[InputPathType | None],
    "base": InputPathType,
    "roi_grid": InputPathType,
    "prefix": str,
    "time": bool,
    "twopass": bool,
    "help": bool,
})
VFastRoiParametersTagged = typing.TypedDict('VFastRoiParametersTagged', {
    "@type": typing.Literal["afni/@fast_roi"],
    "region": list[str],
    "drawn_roi": typing.NotRequired[InputPathType | None],
    "anat": InputPathType,
    "anat_ns": typing.NotRequired[InputPathType | None],
    "base": InputPathType,
    "roi_grid": InputPathType,
    "prefix": str,
    "time": bool,
    "twopass": bool,
    "help": bool,
})


class VFastRoiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VFastRoiParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    roi_output: OutputPathType
    """ROI output volume with the specified prefix."""


def v__fast_roi_params(
    region: list[str],
    anat: InputPathType,
    base: InputPathType,
    roi_grid: InputPathType,
    prefix: str,
    drawn_roi: InputPathType | None = None,
    anat_ns: InputPathType | None = None,
    time_: bool = False,
    twopass: bool = False,
    help_: bool = False,
) -> VFastRoiParametersTagged:
    """
    Build parameters.
    
    Args:
        region: Symbolic atlas-based region name. Use repeated instances to\
            specify a mask of numerous regions. Each region is assigned a power of\
            2 integer in the output mask.
        anat: ANAT is the volume to be put in standard space. If ANAT is\
            already in TLRC space, there is no need for -base option.
        base: Name of the reference TLRC volume.
        roi_grid: The volume that defines the final ROI's grid.
        prefix: Prefix used to tag the names the ROIs output.
        drawn_roi: A user drawn ROI in standard (tlrc) space. This ROI gets\
            added with the REGION ROI.
        anat_ns: Same as -anat, but indicates that the skull has been removed\
            already.
        time_: Output elapsed time reports.
        twopass: Make TLRC transformation more robust. Use it if TLRC transform\
            step fails.
        help_: Output help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@fast_roi",
        "region": region,
        "anat": anat,
        "base": base,
        "roi_grid": roi_grid,
        "prefix": prefix,
        "time": time_,
        "twopass": twopass,
        "help": help_,
    }
    if drawn_roi is not None:
        params["drawn_roi"] = drawn_roi
    if anat_ns is not None:
        params["anat_ns"] = anat_ns
    return params


def v__fast_roi_cargs(
    params: VFastRoiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@fast_roi")
    cargs.extend([
        "-region",
        *params.get("region", None)
    ])
    if params.get("drawn_roi", None) is not None:
        cargs.extend([
            "-drawn_roi",
            execution.input_file(params.get("drawn_roi", None))
        ])
    cargs.extend([
        "-anat",
        execution.input_file(params.get("anat", None))
    ])
    if params.get("anat_ns", None) is not None:
        cargs.extend([
            "-anat_ns",
            execution.input_file(params.get("anat_ns", None))
        ])
    cargs.extend([
        "-base",
        execution.input_file(params.get("base", None))
    ])
    cargs.extend([
        "-roi_grid",
        execution.input_file(params.get("roi_grid", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("prefix", None)
    ])
    if params.get("time", False):
        cargs.append("--time")
    if params.get("twopass", False):
        cargs.append("--twopass")
    if params.get("help", False):
        cargs.append("--help")
    return cargs


def v__fast_roi_outputs(
    params: VFastRoiParameters,
    execution: Execution,
) -> VFastRoiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VFastRoiOutputs(
        root=execution.output_file("."),
        roi_output=execution.output_file("ROI." + params.get("prefix", None) + "+orig"),
    )
    return ret


def v__fast_roi_execute(
    params: VFastRoiParameters,
    runner: Runner | None = None,
) -> VFastRoiOutputs:
    """
    @fast_roi
    
    Creates Atlas-based ROI masked in ANAT's original space. The script executes
    rapidly for realtime fMRI applications.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFastRoiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__FAST_ROI_METADATA)
    params = execution.params(params)
    cargs = v__fast_roi_cargs(params, execution)
    ret = v__fast_roi_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__fast_roi(
    region: list[str],
    anat: InputPathType,
    base: InputPathType,
    roi_grid: InputPathType,
    prefix: str,
    drawn_roi: InputPathType | None = None,
    anat_ns: InputPathType | None = None,
    time_: bool = False,
    twopass: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> VFastRoiOutputs:
    """
    @fast_roi
    
    Creates Atlas-based ROI masked in ANAT's original space. The script executes
    rapidly for realtime fMRI applications.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        region: Symbolic atlas-based region name. Use repeated instances to\
            specify a mask of numerous regions. Each region is assigned a power of\
            2 integer in the output mask.
        anat: ANAT is the volume to be put in standard space. If ANAT is\
            already in TLRC space, there is no need for -base option.
        base: Name of the reference TLRC volume.
        roi_grid: The volume that defines the final ROI's grid.
        prefix: Prefix used to tag the names the ROIs output.
        drawn_roi: A user drawn ROI in standard (tlrc) space. This ROI gets\
            added with the REGION ROI.
        anat_ns: Same as -anat, but indicates that the skull has been removed\
            already.
        time_: Output elapsed time reports.
        twopass: Make TLRC transformation more robust. Use it if TLRC transform\
            step fails.
        help_: Output help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFastRoiOutputs`).
    """
    params = v__fast_roi_params(
        region=region,
        drawn_roi=drawn_roi,
        anat=anat,
        anat_ns=anat_ns,
        base=base,
        roi_grid=roi_grid,
        prefix=prefix,
        time_=time_,
        twopass=twopass,
        help_=help_,
    )
    return v__fast_roi_execute(params, runner)


__all__ = [
    "VFastRoiOutputs",
    "V__FAST_ROI_METADATA",
    "v__fast_roi",
    "v__fast_roi_execute",
    "v__fast_roi_params",
]
