# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__FLOAT_FIX_METADATA = Metadata(
    id="767e876d3f0cfcc45088815cd58010847e88edb7.boutiques",
    name="@float_fix",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VFloatFixParameters = typing.TypedDict('VFloatFixParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@float_fix"]],
    "input_files": list[InputPathType],
})
VFloatFixParametersTagged = typing.TypedDict('VFloatFixParametersTagged', {
    "@type": typing.Literal["afni/@float_fix"],
    "input_files": list[InputPathType],
})


class VFloatFixOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VFloatFixParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__float_fix_params(
    input_files: list[InputPathType],
) -> VFloatFixParametersTagged:
    """
    Build parameters.
    
    Args:
        input_files: Input files to be checked for illegal IEEE floating point\
            values. Wildcards can be used, but filenames must end with .HEAD.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@float_fix",
        "input_files": input_files,
    }
    return params


def v__float_fix_cargs(
    params: VFloatFixParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@float_fix")
    cargs.extend([execution.input_file(f) for f in params.get("input_files", None)])
    return cargs


def v__float_fix_outputs(
    params: VFloatFixParameters,
    execution: Execution,
) -> VFloatFixOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VFloatFixOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__float_fix_execute(
    params: VFloatFixParameters,
    runner: Runner | None = None,
) -> VFloatFixOutputs:
    """
    @float_fix
    
    Check whether the input files have any IEEE floating point numbers for
    illegal values: infinities and not-a-number (NaN) values.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFloatFixOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__FLOAT_FIX_METADATA)
    params = execution.params(params)
    cargs = v__float_fix_cargs(params, execution)
    ret = v__float_fix_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__float_fix(
    input_files: list[InputPathType],
    runner: Runner | None = None,
) -> VFloatFixOutputs:
    """
    @float_fix
    
    Check whether the input files have any IEEE floating point numbers for
    illegal values: infinities and not-a-number (NaN) values.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_files: Input files to be checked for illegal IEEE floating point\
            values. Wildcards can be used, but filenames must end with .HEAD.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFloatFixOutputs`).
    """
    params = v__float_fix_params(
        input_files=input_files,
    )
    return v__float_fix_execute(params, runner)


__all__ = [
    "VFloatFixOutputs",
    "V__FLOAT_FIX_METADATA",
    "v__float_fix",
    "v__float_fix_execute",
    "v__float_fix_params",
]
