# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__FROM_RAI_METADATA = Metadata(
    id="606aa9259f1b8916cc82e8ce0bda762e7da64528.boutiques",
    name="@FromRAI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VFromRaiParameters = typing.TypedDict('VFromRaiParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@FromRAI"]],
    "rai_coordinates": list[float],
    "orientation": str,
})
VFromRaiParametersTagged = typing.TypedDict('VFromRaiParametersTagged', {
    "@type": typing.Literal["afni/@FromRAI"],
    "rai_coordinates": list[float],
    "orientation": str,
})


class VFromRaiOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VFromRaiParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__from_rai_params(
    rai_coordinates: list[float],
    orientation: str,
) -> VFromRaiParametersTagged:
    """
    Build parameters.
    
    Args:
        rai_coordinates: RAI coordinates X, Y, and Z.
        orientation: Orientation format.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@FromRAI",
        "rai_coordinates": rai_coordinates,
        "orientation": orientation,
    }
    return params


def v__from_rai_cargs(
    params: VFromRaiParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@FromRAI")
    cargs.extend([
        "-xyz",
        *map(str, params.get("rai_coordinates", None))
    ])
    cargs.extend([
        "-or",
        params.get("orientation", None)
    ])
    return cargs


def v__from_rai_outputs(
    params: VFromRaiParameters,
    execution: Execution,
) -> VFromRaiOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VFromRaiOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__from_rai_execute(
    params: VFromRaiParameters,
    runner: Runner | None = None,
) -> VFromRaiOutputs:
    """
    @FromRAI
    
    Changes the RAI coordinates to the specified orientation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFromRaiOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__FROM_RAI_METADATA)
    params = execution.params(params)
    cargs = v__from_rai_cargs(params, execution)
    ret = v__from_rai_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__from_rai(
    rai_coordinates: list[float],
    orientation: str,
    runner: Runner | None = None,
) -> VFromRaiOutputs:
    """
    @FromRAI
    
    Changes the RAI coordinates to the specified orientation.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        rai_coordinates: RAI coordinates X, Y, and Z.
        orientation: Orientation format.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFromRaiOutputs`).
    """
    params = v__from_rai_params(
        rai_coordinates=rai_coordinates,
        orientation=orientation,
    )
    return v__from_rai_execute(params, runner)


__all__ = [
    "VFromRaiOutputs",
    "V__FROM_RAI_METADATA",
    "v__from_rai",
    "v__from_rai_execute",
    "v__from_rai_params",
]
