# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__FSLABEL2DSET_METADATA = Metadata(
    id="4ee1b6c7aa619b76203fc0c2ee4f0f2da723c81d.boutiques",
    name="@FSlabel2dset",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VFslabel2dsetParameters = typing.TypedDict('VFslabel2dsetParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@FSlabel2dset"]],
    "fs_label_file": InputPathType,
    "val": typing.NotRequired[float | None],
    "help": bool,
    "echo": bool,
    "keep_tmp": bool,
})
VFslabel2dsetParametersTagged = typing.TypedDict('VFslabel2dsetParametersTagged', {
    "@type": typing.Literal["afni/@FSlabel2dset"],
    "fs_label_file": InputPathType,
    "val": typing.NotRequired[float | None],
    "help": bool,
    "echo": bool,
    "keep_tmp": bool,
})


class VFslabel2dsetOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VFslabel2dsetParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__fslabel2dset_params(
    fs_label_file: InputPathType,
    val: float | None = None,
    help_: bool = False,
    echo: bool = False,
    keep_tmp: bool = False,
) -> VFslabel2dsetParametersTagged:
    """
    Build parameters.
    
    Args:
        fs_label_file: Specify the ASCII label file from FreeSurfer.
        val: Assign integer VAL to the nodes in FS_LABEL_FILE (Default is 1).
        help_: Display help message.
        echo: Turn echo for debugging.
        keep_tmp: Don't cleanup temp files.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@FSlabel2dset",
        "fs_label_file": fs_label_file,
        "help": help_,
        "echo": echo,
        "keep_tmp": keep_tmp,
    }
    if val is not None:
        params["val"] = val
    return params


def v__fslabel2dset_cargs(
    params: VFslabel2dsetParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@FSlabel2dset")
    cargs.extend([
        "-fs",
        execution.input_file(params.get("fs_label_file", None))
    ])
    if params.get("val", None) is not None:
        cargs.extend([
            "-val",
            str(params.get("val", None))
        ])
    if params.get("help", False):
        cargs.append("-help")
    if params.get("echo", False):
        cargs.append("-echo")
    if params.get("keep_tmp", False):
        cargs.append("-keep_tmp")
    return cargs


def v__fslabel2dset_outputs(
    params: VFslabel2dsetParameters,
    execution: Execution,
) -> VFslabel2dsetOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VFslabel2dsetOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__fslabel2dset_execute(
    params: VFslabel2dsetParameters,
    runner: Runner | None = None,
) -> VFslabel2dsetOutputs:
    """
    @FSlabel2dset
    
    A script to convert a FreeSurfer ASCII label file into a SUMA dataset and a
    SUMA ROI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFslabel2dsetOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__FSLABEL2DSET_METADATA)
    params = execution.params(params)
    cargs = v__fslabel2dset_cargs(params, execution)
    ret = v__fslabel2dset_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__fslabel2dset(
    fs_label_file: InputPathType,
    val: float | None = None,
    help_: bool = False,
    echo: bool = False,
    keep_tmp: bool = False,
    runner: Runner | None = None,
) -> VFslabel2dsetOutputs:
    """
    @FSlabel2dset
    
    A script to convert a FreeSurfer ASCII label file into a SUMA dataset and a
    SUMA ROI.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        fs_label_file: Specify the ASCII label file from FreeSurfer.
        val: Assign integer VAL to the nodes in FS_LABEL_FILE (Default is 1).
        help_: Display help message.
        echo: Turn echo for debugging.
        keep_tmp: Don't cleanup temp files.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VFslabel2dsetOutputs`).
    """
    params = v__fslabel2dset_params(
        fs_label_file=fs_label_file,
        val=val,
        help_=help_,
        echo=echo,
        keep_tmp=keep_tmp,
    )
    return v__fslabel2dset_execute(params, runner)


__all__ = [
    "VFslabel2dsetOutputs",
    "V__FSLABEL2DSET_METADATA",
    "v__fslabel2dset",
    "v__fslabel2dset_execute",
    "v__fslabel2dset_params",
]
