# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_DIMS_METADATA = Metadata(
    id="5be17e05d89db2378724c321df4c193a4d74ee28.boutiques",
    name="@GetAfniDims",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniDimsParameters = typing.TypedDict('VGetAfniDimsParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@GetAfniDims"]],
    "input_dset": InputPathType,
})
VGetAfniDimsParametersTagged = typing.TypedDict('VGetAfniDimsParametersTagged', {
    "@type": typing.Literal["afni/@GetAfniDims"],
    "input_dset": InputPathType,
})


class VGetAfniDimsOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniDimsParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    dims_output: OutputPathType
    """Text file containing the dimensions of the input dataset"""


def v__get_afni_dims_params(
    input_dset: InputPathType,
) -> VGetAfniDimsParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dset: Input AFNI dataset.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@GetAfniDims",
        "input_dset": input_dset,
    }
    return params


def v__get_afni_dims_cargs(
    params: VGetAfniDimsParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniDims")
    cargs.append(execution.input_file(params.get("input_dset", None)))
    return cargs


def v__get_afni_dims_outputs(
    params: VGetAfniDimsParameters,
    execution: Execution,
) -> VGetAfniDimsOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniDimsOutputs(
        root=execution.output_file("."),
        dims_output=execution.output_file("dims_output.txt"),
    )
    return ret


def v__get_afni_dims_execute(
    params: VGetAfniDimsParameters,
    runner: Runner | None = None,
) -> VGetAfniDimsOutputs:
    """
    @GetAfniDims
    
    A utility tool to return dimensions of AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniDimsOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_DIMS_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_dims_cargs(params, execution)
    ret = v__get_afni_dims_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_dims(
    input_dset: InputPathType,
    runner: Runner | None = None,
) -> VGetAfniDimsOutputs:
    """
    @GetAfniDims
    
    A utility tool to return dimensions of AFNI dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dset: Input AFNI dataset.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniDimsOutputs`).
    """
    params = v__get_afni_dims_params(
        input_dset=input_dset,
    )
    return v__get_afni_dims_execute(params, runner)


__all__ = [
    "VGetAfniDimsOutputs",
    "V__GET_AFNI_DIMS_METADATA",
    "v__get_afni_dims",
    "v__get_afni_dims_execute",
    "v__get_afni_dims_params",
]
