# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_ID_METADATA = Metadata(
    id="50a1b87d350e86fa8e8ea67a942f00bb2641ad96.boutiques",
    name="@GetAfniID",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniIdParameters = typing.TypedDict('VGetAfniIdParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@GetAfniID"]],
    "dset": InputPathType,
})
VGetAfniIdParametersTagged = typing.TypedDict('VGetAfniIdParametersTagged', {
    "@type": typing.Literal["afni/@GetAfniID"],
    "dset": InputPathType,
})


class VGetAfniIdOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniIdParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    unique_id: OutputPathType
    """Unique identifier of the dataset"""


def v__get_afni_id_params(
    dset: InputPathType,
) -> VGetAfniIdParametersTagged:
    """
    Build parameters.
    
    Args:
        dset: Dataset for which the unique identifier is to be returned.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@GetAfniID",
        "dset": dset,
    }
    return params


def v__get_afni_id_cargs(
    params: VGetAfniIdParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniID")
    cargs.append(execution.input_file(params.get("dset", None)))
    return cargs


def v__get_afni_id_outputs(
    params: VGetAfniIdParameters,
    execution: Execution,
) -> VGetAfniIdOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniIdOutputs(
        root=execution.output_file("."),
        unique_id=execution.output_file("stdout"),
    )
    return ret


def v__get_afni_id_execute(
    params: VGetAfniIdParameters,
    runner: Runner | None = None,
) -> VGetAfniIdOutputs:
    """
    @GetAfniID
    
    Returns the unique identifier of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniIdOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_ID_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_id_cargs(params, execution)
    ret = v__get_afni_id_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_id(
    dset: InputPathType,
    runner: Runner | None = None,
) -> VGetAfniIdOutputs:
    """
    @GetAfniID
    
    Returns the unique identifier of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dset: Dataset for which the unique identifier is to be returned.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniIdOutputs`).
    """
    params = v__get_afni_id_params(
        dset=dset,
    )
    return v__get_afni_id_execute(params, runner)


__all__ = [
    "VGetAfniIdOutputs",
    "V__GET_AFNI_ID_METADATA",
    "v__get_afni_id",
    "v__get_afni_id_execute",
    "v__get_afni_id_params",
]
