# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_ORIENT_METADATA = Metadata(
    id="918b4490cd27c9578336b43b6079765db775bef2.boutiques",
    name="@GetAfniOrient",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniOrientParameters = typing.TypedDict('VGetAfniOrientParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@GetAfniOrient"]],
    "exploratory": bool,
    "infile": InputPathType,
})
VGetAfniOrientParametersTagged = typing.TypedDict('VGetAfniOrientParametersTagged', {
    "@type": typing.Literal["afni/@GetAfniOrient"],
    "exploratory": bool,
    "infile": InputPathType,
})


class VGetAfniOrientOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniOrientParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_orient_code: OutputPathType
    """File containing the orientation code"""


def v__get_afni_orient_params(
    infile: InputPathType,
    exploratory: bool = False,
) -> VGetAfniOrientParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input AFNI dataset (e.g. Hello+orig.HEAD).
        exploratory: Exploratory flag for additional functionalities.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@GetAfniOrient",
        "exploratory": exploratory,
        "infile": infile,
    }
    return params


def v__get_afni_orient_cargs(
    params: VGetAfniOrientParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniOrient")
    if params.get("exploratory", False):
        cargs.append("-exp")
    cargs.append(execution.input_file(params.get("infile", None)))
    return cargs


def v__get_afni_orient_outputs(
    params: VGetAfniOrientParameters,
    execution: Execution,
) -> VGetAfniOrientOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniOrientOutputs(
        root=execution.output_file("."),
        output_orient_code=execution.output_file(pathlib.Path(params.get("infile", None)).name + "_orient_code.txt"),
    )
    return ret


def v__get_afni_orient_execute(
    params: VGetAfniOrientParameters,
    runner: Runner | None = None,
) -> VGetAfniOrientOutputs:
    """
    @GetAfniOrient
    
    Returns the orient code of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniOrientOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_ORIENT_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_orient_cargs(params, execution)
    ret = v__get_afni_orient_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_orient(
    infile: InputPathType,
    exploratory: bool = False,
    runner: Runner | None = None,
) -> VGetAfniOrientOutputs:
    """
    @GetAfniOrient
    
    Returns the orient code of AFNI datasets.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input AFNI dataset (e.g. Hello+orig.HEAD).
        exploratory: Exploratory flag for additional functionalities.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniOrientOutputs`).
    """
    params = v__get_afni_orient_params(
        exploratory=exploratory,
        infile=infile,
    )
    return v__get_afni_orient_execute(params, runner)


__all__ = [
    "VGetAfniOrientOutputs",
    "V__GET_AFNI_ORIENT_METADATA",
    "v__get_afni_orient",
    "v__get_afni_orient_execute",
    "v__get_afni_orient_params",
]
