# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_RES_METADATA = Metadata(
    id="1b660d80a4ac8a3e79aee798185d997a301cebde.boutiques",
    name="@GetAfniRes",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniResParameters = typing.TypedDict('VGetAfniResParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@GetAfniRes"]],
    "output_type": typing.NotRequired[typing.Literal["-min", "-max", "-mean"] | None],
    "input_dataset": InputPathType,
})
VGetAfniResParametersTagged = typing.TypedDict('VGetAfniResParametersTagged', {
    "@type": typing.Literal["afni/@GetAfniRes"],
    "output_type": typing.NotRequired[typing.Literal["-min", "-max", "-mean"] | None],
    "input_dataset": InputPathType,
})


class VGetAfniResOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniResParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__get_afni_res_params(
    input_dataset: InputPathType,
    output_type: typing.Literal["-min", "-max", "-mean"] | None = None,
) -> VGetAfniResParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset.
        output_type: Output type specifying whether to return the minimum,\
            maximum, or mean resolution.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@GetAfniRes",
        "input_dataset": input_dataset,
    }
    if output_type is not None:
        params["output_type"] = output_type
    return params


def v__get_afni_res_cargs(
    params: VGetAfniResParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniRes")
    if params.get("output_type", None) is not None:
        cargs.append(params.get("output_type", None))
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    return cargs


def v__get_afni_res_outputs(
    params: VGetAfniResParameters,
    execution: Execution,
) -> VGetAfniResOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniResOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__get_afni_res_execute(
    params: VGetAfniResParameters,
    runner: Runner | None = None,
) -> VGetAfniResOutputs:
    """
    @GetAfniRes
    
    Tool to return the voxel resolution of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniResOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_RES_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_res_cargs(params, execution)
    ret = v__get_afni_res_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_res(
    input_dataset: InputPathType,
    output_type: typing.Literal["-min", "-max", "-mean"] | None = None,
    runner: Runner | None = None,
) -> VGetAfniResOutputs:
    """
    @GetAfniRes
    
    Tool to return the voxel resolution of a dataset.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset.
        output_type: Output type specifying whether to return the minimum,\
            maximum, or mean resolution.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniResOutputs`).
    """
    params = v__get_afni_res_params(
        output_type=output_type,
        input_dataset=input_dataset,
    )
    return v__get_afni_res_execute(params, runner)


__all__ = [
    "VGetAfniResOutputs",
    "V__GET_AFNI_RES_METADATA",
    "v__get_afni_res",
    "v__get_afni_res_execute",
    "v__get_afni_res_params",
]
