# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_VERSION_METADATA = Metadata(
    id="1ec98dcf0cb2a49d077f5453d4b46fa724ccee35.boutiques",
    name="@get.afni.version",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniVersionParameters = typing.TypedDict('VGetAfniVersionParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@get.afni.version"]],
    "version": str,
})
VGetAfniVersionParametersTagged = typing.TypedDict('VGetAfniVersionParametersTagged', {
    "@type": typing.Literal["afni/@get.afni.version"],
    "version": str,
})


class VGetAfniVersionOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniVersionParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    src_dir: OutputPathType
    """Directory containing the downloaded AFNI source code for the specified
    version."""


def v__get_afni_version_params(
    version: str,
) -> VGetAfniVersionParametersTagged:
    """
    Build parameters.
    
    Args:
        version: AFNI version number to get (e.g., 16.0.01).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@get.afni.version",
        "version": version,
    }
    return params


def v__get_afni_version_cargs(
    params: VGetAfniVersionParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@get.afni.version")
    cargs.append(params.get("version", None))
    return cargs


def v__get_afni_version_outputs(
    params: VGetAfniVersionParameters,
    execution: Execution,
) -> VGetAfniVersionOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniVersionOutputs(
        root=execution.output_file("."),
        src_dir=execution.output_file("AFNI_" + params.get("version", None) + "/AFNI/src"),
    )
    return ret


def v__get_afni_version_execute(
    params: VGetAfniVersionParameters,
    runner: Runner | None = None,
) -> VGetAfniVersionOutputs:
    """
    @get.afni.version
    
    Downloads the source code for a specified AFNI version.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniVersionOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_VERSION_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_version_cargs(params, execution)
    ret = v__get_afni_version_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_version(
    version: str,
    runner: Runner | None = None,
) -> VGetAfniVersionOutputs:
    """
    @get.afni.version
    
    Downloads the source code for a specified AFNI version.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        version: AFNI version number to get (e.g., 16.0.01).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniVersionOutputs`).
    """
    params = v__get_afni_version_params(
        version=version,
    )
    return v__get_afni_version_execute(params, runner)


__all__ = [
    "VGetAfniVersionOutputs",
    "V__GET_AFNI_VERSION_METADATA",
    "v__get_afni_version",
    "v__get_afni_version_execute",
    "v__get_afni_version_params",
]
