# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__GET_AFNI_VIEW_METADATA = Metadata(
    id="20b2a2db50cb609353f0bd8485710f70289b0020.boutiques",
    name="@GetAfniView",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VGetAfniViewParameters = typing.TypedDict('VGetAfniViewParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@GetAfniView"]],
    "dataset_name": str,
})
VGetAfniViewParametersTagged = typing.TypedDict('VGetAfniViewParametersTagged', {
    "@type": typing.Literal["afni/@GetAfniView"],
    "dataset_name": str,
})


class VGetAfniViewOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VGetAfniViewParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    afni_view: OutputPathType
    """The AFNI view extension retrieved from the dataset name"""


def v__get_afni_view_params(
    dataset_name: str,
) -> VGetAfniViewParametersTagged:
    """
    Build parameters.
    
    Args:
        dataset_name: Name of the dataset (including path) from which to\
            retrieve the AFNI view (+orig, +acpc, etc.).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@GetAfniView",
        "dataset_name": dataset_name,
    }
    return params


def v__get_afni_view_cargs(
    params: VGetAfniViewParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@GetAfniView")
    cargs.append(params.get("dataset_name", None))
    return cargs


def v__get_afni_view_outputs(
    params: VGetAfniViewParameters,
    execution: Execution,
) -> VGetAfniViewOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VGetAfniViewOutputs(
        root=execution.output_file("."),
        afni_view=execution.output_file("view_extension.txt"),
    )
    return ret


def v__get_afni_view_execute(
    params: VGetAfniViewParameters,
    runner: Runner | None = None,
) -> VGetAfniViewOutputs:
    """
    @GetAfniView
    
    A tool to retrieve the AFNI view of a given dataset name.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniViewOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__GET_AFNI_VIEW_METADATA)
    params = execution.params(params)
    cargs = v__get_afni_view_cargs(params, execution)
    ret = v__get_afni_view_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__get_afni_view(
    dataset_name: str,
    runner: Runner | None = None,
) -> VGetAfniViewOutputs:
    """
    @GetAfniView
    
    A tool to retrieve the AFNI view of a given dataset name.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        dataset_name: Name of the dataset (including path) from which to\
            retrieve the AFNI view (+orig, +acpc, etc.).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VGetAfniViewOutputs`).
    """
    params = v__get_afni_view_params(
        dataset_name=dataset_name,
    )
    return v__get_afni_view_execute(params, runner)


__all__ = [
    "VGetAfniViewOutputs",
    "V__GET_AFNI_VIEW_METADATA",
    "v__get_afni_view",
    "v__get_afni_view_execute",
    "v__get_afni_view_params",
]
