# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__HELP_AFNI_METADATA = Metadata(
    id="32090db8a8937db4bee1db92c4aaf17394fb1612.boutiques",
    name="@help.AFNI",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VHelpAfniParameters = typing.TypedDict('VHelpAfniParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@help.AFNI"]],
    "match": typing.NotRequired[str | None],
    "lynx": bool,
    "vi": bool,
    "less": bool,
    "nedit": bool,
    "noview": bool,
})
VHelpAfniParametersTagged = typing.TypedDict('VHelpAfniParametersTagged', {
    "@type": typing.Literal["afni/@help.AFNI"],
    "match": typing.NotRequired[str | None],
    "lynx": bool,
    "vi": bool,
    "less": bool,
    "nedit": bool,
    "noview": bool,
})


class VHelpAfniOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VHelpAfniParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__help_afni_params(
    match: str | None = None,
    lynx: bool = False,
    vi: bool = False,
    less: bool = False,
    nedit: bool = False,
    noview: bool = False,
) -> VHelpAfniParametersTagged:
    """
    Build parameters.
    
    Args:
        match: Looks for occurrence of each word in the list in the help file.\
            For a match with multiple words, all the words must be on the same line\
            of text in the help file.
        lynx: Set viewer to lynx.
        vi: Set viewer to vi.
        less: Set viewer to less (default).
        nedit: Set viewer to nedit.
        noview: Set viewer to no view.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@help.AFNI",
        "lynx": lynx,
        "vi": vi,
        "less": less,
        "nedit": nedit,
        "noview": noview,
    }
    if match is not None:
        params["match"] = match
    return params


def v__help_afni_cargs(
    params: VHelpAfniParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@help.AFNI")
    if params.get("match", None) is not None:
        cargs.extend([
            "-match",
            params.get("match", None)
        ])
    if params.get("lynx", False):
        cargs.append("-lynx")
    if params.get("vi", False):
        cargs.append("-vi")
    if params.get("less", False):
        cargs.append("-less")
    if params.get("nedit", False):
        cargs.append("-nedit")
    if params.get("noview", False):
        cargs.append("-noview")
    return cargs


def v__help_afni_outputs(
    params: VHelpAfniParameters,
    execution: Execution,
) -> VHelpAfniOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VHelpAfniOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__help_afni_execute(
    params: VHelpAfniParameters,
    runner: Runner | None = None,
) -> VHelpAfniOutputs:
    """
    @help.AFNI
    
    A script to retrieve and search AFNI's help page for all programs.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VHelpAfniOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__HELP_AFNI_METADATA)
    params = execution.params(params)
    cargs = v__help_afni_cargs(params, execution)
    ret = v__help_afni_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__help_afni(
    match: str | None = None,
    lynx: bool = False,
    vi: bool = False,
    less: bool = False,
    nedit: bool = False,
    noview: bool = False,
    runner: Runner | None = None,
) -> VHelpAfniOutputs:
    """
    @help.AFNI
    
    A script to retrieve and search AFNI's help page for all programs.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        match: Looks for occurrence of each word in the list in the help file.\
            For a match with multiple words, all the words must be on the same line\
            of text in the help file.
        lynx: Set viewer to lynx.
        vi: Set viewer to vi.
        less: Set viewer to less (default).
        nedit: Set viewer to nedit.
        noview: Set viewer to no view.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VHelpAfniOutputs`).
    """
    params = v__help_afni_params(
        match=match,
        lynx=lynx,
        vi=vi,
        less=less,
        nedit=nedit,
        noview=noview,
    )
    return v__help_afni_execute(params, runner)


__all__ = [
    "VHelpAfniOutputs",
    "V__HELP_AFNI_METADATA",
    "v__help_afni",
    "v__help_afni_execute",
    "v__help_afni_params",
]
