# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__IS_OBLIQUE_METADATA = Metadata(
    id="1db61c294d0093711594ad61dae63fc37edee3bb.boutiques",
    name="@isOblique",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VIsObliqueParameters = typing.TypedDict('VIsObliqueParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@isOblique"]],
    "infile": InputPathType,
})
VIsObliqueParametersTagged = typing.TypedDict('VIsObliqueParametersTagged', {
    "@type": typing.Literal["afni/@isOblique"],
    "infile": InputPathType,
})


class VIsObliqueOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VIsObliqueParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    result: OutputPathType
    """Output result indicating if the file is oblique or plumb"""


def v__is_oblique_params(
    infile: InputPathType,
) -> VIsObliqueParametersTagged:
    """
    Build parameters.
    
    Args:
        infile: Input file (e.g., Hello+orig.HEAD).
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@isOblique",
        "infile": infile,
    }
    return params


def v__is_oblique_cargs(
    params: VIsObliqueParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@isOblique")
    cargs.append(execution.input_file(params.get("infile", None)))
    return cargs


def v__is_oblique_outputs(
    params: VIsObliqueParameters,
    execution: Execution,
) -> VIsObliqueOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VIsObliqueOutputs(
        root=execution.output_file("."),
        result=execution.output_file("oblique_check_result.txt"),
    )
    return ret


def v__is_oblique_execute(
    params: VIsObliqueParameters,
    runner: Runner | None = None,
) -> VIsObliqueOutputs:
    """
    @isOblique
    
    Determine if a file is oblique or plumb.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VIsObliqueOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__IS_OBLIQUE_METADATA)
    params = execution.params(params)
    cargs = v__is_oblique_cargs(params, execution)
    ret = v__is_oblique_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__is_oblique(
    infile: InputPathType,
    runner: Runner | None = None,
) -> VIsObliqueOutputs:
    """
    @isOblique
    
    Determine if a file is oblique or plumb.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        infile: Input file (e.g., Hello+orig.HEAD).
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VIsObliqueOutputs`).
    """
    params = v__is_oblique_params(
        infile=infile,
    )
    return v__is_oblique_execute(params, runner)


__all__ = [
    "VIsObliqueOutputs",
    "V__IS_OBLIQUE_METADATA",
    "v__is_oblique",
    "v__is_oblique_execute",
    "v__is_oblique_params",
]
