# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__MEASURE_EROSION_THICK_METADATA = Metadata(
    id="38a8daf5a4a8dae931166c9e1c03b44c10b6b8df.boutiques",
    name="@measure_erosion_thick",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VMeasureErosionThickParameters = typing.TypedDict('VMeasureErosionThickParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@measure_erosion_thick"]],
    "maskset": InputPathType,
    "surfset": InputPathType,
    "outdir": typing.NotRequired[str | None],
    "resample": typing.NotRequired[str | None],
    "surfsmooth": typing.NotRequired[float | None],
    "smoothmm": typing.NotRequired[float | None],
    "maxthick": typing.NotRequired[float | None],
    "depthsearch": typing.NotRequired[float | None],
    "keep_temp_files": bool,
    "surfsmooth_method": typing.NotRequired[str | None],
})
VMeasureErosionThickParametersTagged = typing.TypedDict('VMeasureErosionThickParametersTagged', {
    "@type": typing.Literal["afni/@measure_erosion_thick"],
    "maskset": InputPathType,
    "surfset": InputPathType,
    "outdir": typing.NotRequired[str | None],
    "resample": typing.NotRequired[str | None],
    "surfsmooth": typing.NotRequired[float | None],
    "smoothmm": typing.NotRequired[float | None],
    "maxthick": typing.NotRequired[float | None],
    "depthsearch": typing.NotRequired[float | None],
    "keep_temp_files": bool,
    "surfsmooth_method": typing.NotRequired[str | None],
})


class VMeasureErosionThickOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VMeasureErosionThickParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    erosion_depth: OutputPathType
    """Depth dataset."""
    erosion_thick: OutputPathType
    """Volumetric thickness dataset."""
    erosion_thick_smooth: OutputPathType
    """Smoothed volumetric thickness dataset."""
    erosion_thick_niml: OutputPathType
    """Unsmoothed thickness mapped to surface nodes."""
    erosion_thick_smooth_niml: OutputPathType
    """Smoothed thickness mapped to surface nodes."""
    maskset_output: OutputPathType
    """Mask dataset."""
    resampled_maskset: OutputPathType
    """Resampled mask dataset."""
    anat_gii: OutputPathType
    """Surface representation of mask volume."""
    quick_spec: OutputPathType
    """Simple specification file for surface to use with suma commands."""


def v__measure_erosion_thick_params(
    maskset: InputPathType,
    surfset: InputPathType,
    outdir: str | None = None,
    resample: str | None = None,
    surfsmooth: float | None = None,
    smoothmm: float | None = None,
    maxthick: float | None = None,
    depthsearch: float | None = None,
    keep_temp_files: bool = False,
    surfsmooth_method: str | None = None,
) -> VMeasureErosionThickParametersTagged:
    """
    Build parameters.
    
    Args:
        maskset: Mask dataset for input.
        surfset: Surface dataset onto which to map thickness (probably a\
            pial/gray matter surface).
        outdir: Output directory. If not specified, erosion_thickdir is used.
        resample: Resample input to mm in millimeters (put a number here).\
            Recommended for most 1mm data.
        surfsmooth: Smooth surface map of thickness by mm millimeters. Default\
            is 8 mm.
        smoothmm: Smooth volume by mm FWHM in mask. Default is 2*voxelsize of\
            mask or resampled mask.
        maxthick: Search for maximum thickness value of mm millimeters. Default\
            is 6 mm.
        depthsearch: Map to surface by looking for max along mm millimeter\
            normal vectors. Default is 3 mm.
        keep_temp_files: Do not delete the intermediate files (for testing).
        surfsmooth_method: Heat method used for smoothing surfaces. Default is\
            HEAT_07 but HEAT_05 is also useful for models.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@measure_erosion_thick",
        "maskset": maskset,
        "surfset": surfset,
        "keep_temp_files": keep_temp_files,
    }
    if outdir is not None:
        params["outdir"] = outdir
    if resample is not None:
        params["resample"] = resample
    if surfsmooth is not None:
        params["surfsmooth"] = surfsmooth
    if smoothmm is not None:
        params["smoothmm"] = smoothmm
    if maxthick is not None:
        params["maxthick"] = maxthick
    if depthsearch is not None:
        params["depthsearch"] = depthsearch
    if surfsmooth_method is not None:
        params["surfsmooth_method"] = surfsmooth_method
    return params


def v__measure_erosion_thick_cargs(
    params: VMeasureErosionThickParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@measure_erosion_thick")
    cargs.extend([
        "-maskset",
        execution.input_file(params.get("maskset", None))
    ])
    cargs.extend([
        "-surfset",
        execution.input_file(params.get("surfset", None))
    ])
    if params.get("outdir", None) is not None:
        cargs.extend([
            "-outdir",
            params.get("outdir", None)
        ])
    if params.get("resample", None) is not None:
        cargs.extend([
            "-resample",
            params.get("resample", None)
        ])
    if params.get("surfsmooth", None) is not None:
        cargs.extend([
            "-surfsmooth",
            str(params.get("surfsmooth", None))
        ])
    if params.get("smoothmm", None) is not None:
        cargs.extend([
            "-smoothmm",
            str(params.get("smoothmm", None))
        ])
    if params.get("maxthick", None) is not None:
        cargs.extend([
            "-maxthick",
            str(params.get("maxthick", None))
        ])
    if params.get("depthsearch", None) is not None:
        cargs.extend([
            "-depthsearch",
            str(params.get("depthsearch", None))
        ])
    if params.get("keep_temp_files", False):
        cargs.append("-keep_temp_files")
    if params.get("surfsmooth_method", None) is not None:
        cargs.extend([
            "-surfsmooth_method",
            params.get("surfsmooth_method", None)
        ])
    return cargs


def v__measure_erosion_thick_outputs(
    params: VMeasureErosionThickParameters,
    execution: Execution,
) -> VMeasureErosionThickOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VMeasureErosionThickOutputs(
        root=execution.output_file("."),
        erosion_depth=execution.output_file("erosion_depth.nii.gz"),
        erosion_thick=execution.output_file("erosion_thick.nii.gz"),
        erosion_thick_smooth=execution.output_file("erosion_thick_smooth.nii.gz"),
        erosion_thick_niml=execution.output_file("erosion_thick.niml.dset"),
        erosion_thick_smooth_niml=execution.output_file("erosion_thick_smooth_nn_mm.niml.dset"),
        maskset_output=execution.output_file("maskset.nii.gz"),
        resampled_maskset=execution.output_file("maskset_rs.nii.gz"),
        anat_gii=execution.output_file("anat.gii"),
        quick_spec=execution.output_file("quick.spec"),
    )
    return ret


def v__measure_erosion_thick_execute(
    params: VMeasureErosionThickParameters,
    runner: Runner | None = None,
) -> VMeasureErosionThickOutputs:
    """
    @measure_erosion_thick
    
    Compute thickness of mask using erosion method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VMeasureErosionThickOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__MEASURE_EROSION_THICK_METADATA)
    params = execution.params(params)
    cargs = v__measure_erosion_thick_cargs(params, execution)
    ret = v__measure_erosion_thick_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__measure_erosion_thick(
    maskset: InputPathType,
    surfset: InputPathType,
    outdir: str | None = None,
    resample: str | None = None,
    surfsmooth: float | None = None,
    smoothmm: float | None = None,
    maxthick: float | None = None,
    depthsearch: float | None = None,
    keep_temp_files: bool = False,
    surfsmooth_method: str | None = None,
    runner: Runner | None = None,
) -> VMeasureErosionThickOutputs:
    """
    @measure_erosion_thick
    
    Compute thickness of mask using erosion method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        maskset: Mask dataset for input.
        surfset: Surface dataset onto which to map thickness (probably a\
            pial/gray matter surface).
        outdir: Output directory. If not specified, erosion_thickdir is used.
        resample: Resample input to mm in millimeters (put a number here).\
            Recommended for most 1mm data.
        surfsmooth: Smooth surface map of thickness by mm millimeters. Default\
            is 8 mm.
        smoothmm: Smooth volume by mm FWHM in mask. Default is 2*voxelsize of\
            mask or resampled mask.
        maxthick: Search for maximum thickness value of mm millimeters. Default\
            is 6 mm.
        depthsearch: Map to surface by looking for max along mm millimeter\
            normal vectors. Default is 3 mm.
        keep_temp_files: Do not delete the intermediate files (for testing).
        surfsmooth_method: Heat method used for smoothing surfaces. Default is\
            HEAT_07 but HEAT_05 is also useful for models.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VMeasureErosionThickOutputs`).
    """
    params = v__measure_erosion_thick_params(
        maskset=maskset,
        surfset=surfset,
        outdir=outdir,
        resample=resample,
        surfsmooth=surfsmooth,
        smoothmm=smoothmm,
        maxthick=maxthick,
        depthsearch=depthsearch,
        keep_temp_files=keep_temp_files,
        surfsmooth_method=surfsmooth_method,
    )
    return v__measure_erosion_thick_execute(params, runner)


__all__ = [
    "VMeasureErosionThickOutputs",
    "V__MEASURE_EROSION_THICK_METADATA",
    "v__measure_erosion_thick",
    "v__measure_erosion_thick_execute",
    "v__measure_erosion_thick_params",
]
