# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__MEASURE_IN2OUT_METADATA = Metadata(
    id="2aaf2876f213e52543ed8cf4135338ef0c4ff428.boutiques",
    name="@measure_in2out",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VMeasureIn2outParameters = typing.TypedDict('VMeasureIn2outParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@measure_in2out"]],
    "maskset": InputPathType,
    "surfset": InputPathType,
    "outdir": str,
    "resample": typing.NotRequired[str | None],
    "increment": typing.NotRequired[float | None],
    "surfsmooth": typing.NotRequired[float | None],
    "maxthick": typing.NotRequired[float | None],
    "depthsearch": typing.NotRequired[float | None],
    "maskinoutvals": typing.NotRequired[list[float] | None],
    "keep_temp_files": bool,
    "surfsmooth_method": typing.NotRequired[str | None],
    "fs_cort_dir": typing.NotRequired[str | None],
})
VMeasureIn2outParametersTagged = typing.TypedDict('VMeasureIn2outParametersTagged', {
    "@type": typing.Literal["afni/@measure_in2out"],
    "maskset": InputPathType,
    "surfset": InputPathType,
    "outdir": str,
    "resample": typing.NotRequired[str | None],
    "increment": typing.NotRequired[float | None],
    "surfsmooth": typing.NotRequired[float | None],
    "maxthick": typing.NotRequired[float | None],
    "depthsearch": typing.NotRequired[float | None],
    "maskinoutvals": typing.NotRequired[list[float] | None],
    "keep_temp_files": bool,
    "surfsmooth_method": typing.NotRequired[str | None],
    "fs_cort_dir": typing.NotRequired[str | None],
})


class VMeasureIn2outOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VMeasureIn2outParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    inout_dist: OutputPathType
    """Volumetric thickness/distance from in to out"""
    in_and_out: OutputPathType
    """Volumetric distance to inside and outside in 2 volumes"""
    inout_thick: OutputPathType
    """Unsmoothed thickness mapped to surface nodes"""
    inout_thick_smooth: OutputPathType
    """Smoothed thickness mapped to surface nodes"""
    maskset_output: OutputPathType
    """Mask file"""
    maskset_rs: OutputPathType
    """Resampled mask file"""
    anat_gii: OutputPathType
    """Surface representation of mask volume"""
    quick_spec: OutputPathType
    """Simple specification file for surface to use with suma commands"""


def v__measure_in2out_params(
    maskset: InputPathType,
    surfset: InputPathType,
    outdir: str,
    resample: str | None = None,
    increment: float | None = None,
    surfsmooth: float | None = None,
    maxthick: float | None = None,
    depthsearch: float | None = None,
    maskinoutvals: list[float] | None = None,
    keep_temp_files: bool = False,
    surfsmooth_method: str | None = None,
    fs_cort_dir: str | None = None,
) -> VMeasureIn2outParametersTagged:
    """
    Build parameters.
    
    Args:
        maskset: Mask dataset for input.
        surfset: Surface dataset onto which to map thickness (probably a\
            pial/gray matter surface).
        outdir: Output directory. If not specified, in2out_thickdir is used.
        resample: Resample input to mm in millimeters (put a number here). Set\
            this to half a voxel or "auto". No resampling is done by default.\
            Resampling is highly recommended for most 1mm data.
        increment: Test thickness at increments of sub-voxel distance. Default\
            is 1/4 voxel minimum distance (in-plane).
        surfsmooth: Smooth surface map of thickness by mm millimeters. Default\
            is 6 mm.
        maxthick: Search for maximum thickness value of mm millimeters. Default\
            is 6 mm.
        depthsearch: Map to surface by looking for max along mm millimeter\
            normal vectors. Default is 3 mm.
        maskinoutvals: Use v1 for value of mask, v2 and v3 for inside and\
            outside mask values (e.g., '1 -2 -1').
        keep_temp_files: Do not delete the intermediate files (for testing).
        surfsmooth_method: Heat method used for smoothing surfaces. Default is\
            HEAT_07 but HEAT_05 is also useful for some models.
        fs_cort_dir: Use FreeSurfer SUMA directory from @SUMA_Make_Spec_FS for\
            processing.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@measure_in2out",
        "maskset": maskset,
        "surfset": surfset,
        "outdir": outdir,
        "keep_temp_files": keep_temp_files,
    }
    if resample is not None:
        params["resample"] = resample
    if increment is not None:
        params["increment"] = increment
    if surfsmooth is not None:
        params["surfsmooth"] = surfsmooth
    if maxthick is not None:
        params["maxthick"] = maxthick
    if depthsearch is not None:
        params["depthsearch"] = depthsearch
    if maskinoutvals is not None:
        params["maskinoutvals"] = maskinoutvals
    if surfsmooth_method is not None:
        params["surfsmooth_method"] = surfsmooth_method
    if fs_cort_dir is not None:
        params["fs_cort_dir"] = fs_cort_dir
    return params


def v__measure_in2out_cargs(
    params: VMeasureIn2outParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@measure_in2out")
    cargs.extend([
        "-maskset",
        execution.input_file(params.get("maskset", None))
    ])
    cargs.extend([
        "-surfset",
        execution.input_file(params.get("surfset", None))
    ])
    cargs.extend([
        "-outdir",
        params.get("outdir", None)
    ])
    if params.get("resample", None) is not None:
        cargs.extend([
            "-resample",
            params.get("resample", None)
        ])
    if params.get("increment", None) is not None:
        cargs.extend([
            "-increment",
            str(params.get("increment", None))
        ])
    if params.get("surfsmooth", None) is not None:
        cargs.extend([
            "-surfsmooth",
            str(params.get("surfsmooth", None))
        ])
    if params.get("maxthick", None) is not None:
        cargs.extend([
            "-maxthick",
            str(params.get("maxthick", None))
        ])
    if params.get("depthsearch", None) is not None:
        cargs.extend([
            "-depthsearch",
            str(params.get("depthsearch", None))
        ])
    if params.get("maskinoutvals", None) is not None:
        cargs.extend([
            "-maskinoutvals",
            *map(str, params.get("maskinoutvals", None))
        ])
    if params.get("keep_temp_files", False):
        cargs.append("-keep_temp_files")
    if params.get("surfsmooth_method", None) is not None:
        cargs.extend([
            "-surfsmooth_method",
            params.get("surfsmooth_method", None)
        ])
    if params.get("fs_cort_dir", None) is not None:
        cargs.extend([
            "-fs_cort_dir",
            params.get("fs_cort_dir", None)
        ])
    return cargs


def v__measure_in2out_outputs(
    params: VMeasureIn2outParameters,
    execution: Execution,
) -> VMeasureIn2outOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VMeasureIn2outOutputs(
        root=execution.output_file("."),
        inout_dist=execution.output_file("inout_dist.nii.gz"),
        in_and_out=execution.output_file("in_and_out.nii.gz"),
        inout_thick=execution.output_file("inout_thick.niml.dset"),
        inout_thick_smooth=execution.output_file("inout_thick_smooth.niml.dset"),
        maskset_output=execution.output_file("maskset.nii.gz"),
        maskset_rs=execution.output_file("maskset_rs.nii.gz"),
        anat_gii=execution.output_file("anat.gii"),
        quick_spec=execution.output_file("quick.spec"),
    )
    return ret


def v__measure_in2out_execute(
    params: VMeasureIn2outParameters,
    runner: Runner | None = None,
) -> VMeasureIn2outOutputs:
    """
    @measure_in2out
    
    Compute thickness of mask using in2out method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VMeasureIn2outOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__MEASURE_IN2OUT_METADATA)
    params = execution.params(params)
    cargs = v__measure_in2out_cargs(params, execution)
    ret = v__measure_in2out_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__measure_in2out(
    maskset: InputPathType,
    surfset: InputPathType,
    outdir: str,
    resample: str | None = None,
    increment: float | None = None,
    surfsmooth: float | None = None,
    maxthick: float | None = None,
    depthsearch: float | None = None,
    maskinoutvals: list[float] | None = None,
    keep_temp_files: bool = False,
    surfsmooth_method: str | None = None,
    fs_cort_dir: str | None = None,
    runner: Runner | None = None,
) -> VMeasureIn2outOutputs:
    """
    @measure_in2out
    
    Compute thickness of mask using in2out method.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        maskset: Mask dataset for input.
        surfset: Surface dataset onto which to map thickness (probably a\
            pial/gray matter surface).
        outdir: Output directory. If not specified, in2out_thickdir is used.
        resample: Resample input to mm in millimeters (put a number here). Set\
            this to half a voxel or "auto". No resampling is done by default.\
            Resampling is highly recommended for most 1mm data.
        increment: Test thickness at increments of sub-voxel distance. Default\
            is 1/4 voxel minimum distance (in-plane).
        surfsmooth: Smooth surface map of thickness by mm millimeters. Default\
            is 6 mm.
        maxthick: Search for maximum thickness value of mm millimeters. Default\
            is 6 mm.
        depthsearch: Map to surface by looking for max along mm millimeter\
            normal vectors. Default is 3 mm.
        maskinoutvals: Use v1 for value of mask, v2 and v3 for inside and\
            outside mask values (e.g., '1 -2 -1').
        keep_temp_files: Do not delete the intermediate files (for testing).
        surfsmooth_method: Heat method used for smoothing surfaces. Default is\
            HEAT_07 but HEAT_05 is also useful for some models.
        fs_cort_dir: Use FreeSurfer SUMA directory from @SUMA_Make_Spec_FS for\
            processing.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VMeasureIn2outOutputs`).
    """
    params = v__measure_in2out_params(
        maskset=maskset,
        surfset=surfset,
        outdir=outdir,
        resample=resample,
        increment=increment,
        surfsmooth=surfsmooth,
        maxthick=maxthick,
        depthsearch=depthsearch,
        maskinoutvals=maskinoutvals,
        keep_temp_files=keep_temp_files,
        surfsmooth_method=surfsmooth_method,
        fs_cort_dir=fs_cort_dir,
    )
    return v__measure_in2out_execute(params, runner)


__all__ = [
    "VMeasureIn2outOutputs",
    "V__MEASURE_IN2OUT_METADATA",
    "v__measure_in2out",
    "v__measure_in2out_execute",
    "v__measure_in2out_params",
]
