# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__NO_EXT_METADATA = Metadata(
    id="74a67fecd0b092c695e69d2570c50eb30c42f685.boutiques",
    name="@NoExt",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VNoExtParameters = typing.TypedDict('VNoExtParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@NoExt"]],
    "inputfile": str,
    "extensions": typing.NotRequired[list[str] | None],
})
VNoExtParametersTagged = typing.TypedDict('VNoExtParametersTagged', {
    "@type": typing.Literal["afni/@NoExt"],
    "inputfile": str,
    "extensions": typing.NotRequired[list[str] | None],
})


class VNoExtOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VNoExtParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    outfile: OutputPathType
    """File name with specified extensions removed"""


def v__no_ext_params(
    inputfile: str,
    extensions: list[str] | None = None,
) -> VNoExtParametersTagged:
    """
    Build parameters.
    
    Args:
        inputfile: Input file name with extension.
        extensions: Extensions to be removed.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@NoExt",
        "inputfile": inputfile,
    }
    if extensions is not None:
        params["extensions"] = extensions
    return params


def v__no_ext_cargs(
    params: VNoExtParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@NoExt")
    cargs.append(params.get("inputfile", None))
    if params.get("extensions", None) is not None:
        cargs.extend(params.get("extensions", None))
    return cargs


def v__no_ext_outputs(
    params: VNoExtParameters,
    execution: Execution,
) -> VNoExtOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VNoExtOutputs(
        root=execution.output_file("."),
        outfile=execution.output_file("output"),
    )
    return ret


def v__no_ext_execute(
    params: VNoExtParameters,
    runner: Runner | None = None,
) -> VNoExtOutputs:
    """
    @NoExt
    
    Tool for removing specified extensions from filenames.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VNoExtOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__NO_EXT_METADATA)
    params = execution.params(params)
    cargs = v__no_ext_cargs(params, execution)
    ret = v__no_ext_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__no_ext(
    inputfile: str,
    extensions: list[str] | None = None,
    runner: Runner | None = None,
) -> VNoExtOutputs:
    """
    @NoExt
    
    Tool for removing specified extensions from filenames.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        inputfile: Input file name with extension.
        extensions: Extensions to be removed.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VNoExtOutputs`).
    """
    params = v__no_ext_params(
        inputfile=inputfile,
        extensions=extensions,
    )
    return v__no_ext_execute(params, runner)


__all__ = [
    "VNoExtOutputs",
    "V__NO_EXT_METADATA",
    "v__no_ext",
    "v__no_ext_execute",
    "v__no_ext_params",
]
