# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__REORDER_METADATA = Metadata(
    id="cd46479c358c4447d40503c639bbd80f9c31e06b.boutiques",
    name="@Reorder",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VReorderParameters = typing.TypedDict('VReorderParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@Reorder"]],
    "input_dataset": InputPathType,
    "mapfile": InputPathType,
    "prefix": str,
    "offset": typing.NotRequired[float | None],
    "save_work": bool,
    "test": bool,
    "help": bool,
})
VReorderParametersTagged = typing.TypedDict('VReorderParametersTagged', {
    "@type": typing.Literal["afni/@Reorder"],
    "input_dataset": InputPathType,
    "mapfile": InputPathType,
    "prefix": str,
    "offset": typing.NotRequired[float | None],
    "save_work": bool,
    "test": bool,
    "help": bool,
})


class VReorderOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VReorderParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_dataset: OutputPathType
    """Reordered output dataset"""


def v__reorder_params(
    input_dataset: InputPathType,
    mapfile: InputPathType,
    prefix: str,
    offset: float | None = None,
    save_work: bool = False,
    test: bool = False,
    help_: bool = False,
) -> VReorderParametersTagged:
    """
    Build parameters.
    
    Args:
        input_dataset: Input dataset to reorder (e.g. EPI+tlrc).
        mapfile: TR to event mapping file (e.g. events.txt).
        prefix: Prefix for the output dataset.
        offset: Offset mapfile TR indices by OFFSET (in TRs).
        save_work: Do not delete work directory (reorder.work.dir) at the end.
        test: Just report sub-bricks, do not create datasets.
        help_: Show help message.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@Reorder",
        "input_dataset": input_dataset,
        "mapfile": mapfile,
        "prefix": prefix,
        "save_work": save_work,
        "test": test,
        "help": help_,
    }
    if offset is not None:
        params["offset"] = offset
    return params


def v__reorder_cargs(
    params: VReorderParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@Reorder")
    cargs.append(execution.input_file(params.get("input_dataset", None)))
    cargs.append(execution.input_file(params.get("mapfile", None)))
    cargs.append(params.get("prefix", None))
    if params.get("offset", None) is not None:
        cargs.extend([
            "-offset",
            str(params.get("offset", None))
        ])
    if params.get("save_work", False):
        cargs.append("-save_work")
    if params.get("test", False):
        cargs.append("-test")
    if params.get("help", False):
        cargs.append("-help")
    return cargs


def v__reorder_outputs(
    params: VReorderParameters,
    execution: Execution,
) -> VReorderOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VReorderOutputs(
        root=execution.output_file("."),
        output_dataset=execution.output_file(params.get("prefix", None) + "+tlrc"),
    )
    return ret


def v__reorder_execute(
    params: VReorderParameters,
    runner: Runner | None = None,
) -> VReorderOutputs:
    """
    @Reorder
    
    Reorder sub-bricks of a dataset based on event mapping. Works similarly to
    the Reorder plugin.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VReorderOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__REORDER_METADATA)
    params = execution.params(params)
    cargs = v__reorder_cargs(params, execution)
    ret = v__reorder_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__reorder(
    input_dataset: InputPathType,
    mapfile: InputPathType,
    prefix: str,
    offset: float | None = None,
    save_work: bool = False,
    test: bool = False,
    help_: bool = False,
    runner: Runner | None = None,
) -> VReorderOutputs:
    """
    @Reorder
    
    Reorder sub-bricks of a dataset based on event mapping. Works similarly to
    the Reorder plugin.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_dataset: Input dataset to reorder (e.g. EPI+tlrc).
        mapfile: TR to event mapping file (e.g. events.txt).
        prefix: Prefix for the output dataset.
        offset: Offset mapfile TR indices by OFFSET (in TRs).
        save_work: Do not delete work directory (reorder.work.dir) at the end.
        test: Just report sub-bricks, do not create datasets.
        help_: Show help message.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VReorderOutputs`).
    """
    params = v__reorder_params(
        input_dataset=input_dataset,
        mapfile=mapfile,
        prefix=prefix,
        offset=offset,
        save_work=save_work,
        test=test,
        help_=help_,
    )
    return v__reorder_execute(params, runner)


__all__ = [
    "VReorderOutputs",
    "V__REORDER_METADATA",
    "v__reorder",
    "v__reorder_execute",
    "v__reorder_params",
]
