# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SCRIPT_CHECK_METADATA = Metadata(
    id="ecd2a9292bb7df5d7ef5d0acef0705326b404a49.boutiques",
    name="@ScriptCheck",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VScriptCheckParameters = typing.TypedDict('VScriptCheckParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@ScriptCheck"]],
    "clean": bool,
    "suffix": typing.NotRequired[str | None],
    "scripts": list[InputPathType],
})
VScriptCheckParametersTagged = typing.TypedDict('VScriptCheckParametersTagged', {
    "@type": typing.Literal["afni/@ScriptCheck"],
    "clean": bool,
    "suffix": typing.NotRequired[str | None],
    "scripts": list[InputPathType],
})


class VScriptCheckOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VScriptCheckParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    uncleaned_file: OutputPathType
    """Uncleaned original file with specified suffix"""
    cleaned_file: OutputPathType
    """Cleaned file if -clean option is used"""


def v__script_check_params(
    scripts: list[InputPathType],
    clean: bool = False,
    suffix: str | None = None,
) -> VScriptCheckParametersTagged:
    """
    Build parameters.
    
    Args:
        scripts: Scripts to be checked for improperly terminated lines.
        clean: Clean bad line breaks.
        suffix: Rename uncleaned file with specified suffix. Default is .uncln.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@ScriptCheck",
        "clean": clean,
        "scripts": scripts,
    }
    if suffix is not None:
        params["suffix"] = suffix
    return params


def v__script_check_cargs(
    params: VScriptCheckParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@ScriptCheck")
    if params.get("clean", False):
        cargs.append("-clean")
    if params.get("suffix", None) is not None:
        cargs.extend([
            "-suffix",
            params.get("suffix", None)
        ])
    cargs.extend([execution.input_file(f) for f in params.get("scripts", None)])
    return cargs


def v__script_check_outputs(
    params: VScriptCheckParameters,
    execution: Execution,
) -> VScriptCheckOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VScriptCheckOutputs(
        root=execution.output_file("."),
        uncleaned_file=execution.output_file("{SCRIPT}.uncln"),
        cleaned_file=execution.output_file("{SCRIPT}"),
    )
    return ret


def v__script_check_execute(
    params: VScriptCheckParameters,
    runner: Runner | None = None,
) -> VScriptCheckOutputs:
    """
    @ScriptCheck
    
    Checks scripts for improperly terminated lines and optionally cleans them.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VScriptCheckOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SCRIPT_CHECK_METADATA)
    params = execution.params(params)
    cargs = v__script_check_cargs(params, execution)
    ret = v__script_check_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__script_check(
    scripts: list[InputPathType],
    clean: bool = False,
    suffix: str | None = None,
    runner: Runner | None = None,
) -> VScriptCheckOutputs:
    """
    @ScriptCheck
    
    Checks scripts for improperly terminated lines and optionally cleans them.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        scripts: Scripts to be checked for improperly terminated lines.
        clean: Clean bad line breaks.
        suffix: Rename uncleaned file with specified suffix. Default is .uncln.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VScriptCheckOutputs`).
    """
    params = v__script_check_params(
        clean=clean,
        suffix=suffix,
        scripts=scripts,
    )
    return v__script_check_execute(params, runner)


__all__ = [
    "VScriptCheckOutputs",
    "V__SCRIPT_CHECK_METADATA",
    "v__script_check",
    "v__script_check_execute",
    "v__script_check_params",
]
