# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SNAPSHOT_VOLREG_METADATA = Metadata(
    id="ea426c0369e8313557cfb4056ece5365e472d055.boutiques",
    name="@snapshot_volreg",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSnapshotVolregParameters = typing.TypedDict('VSnapshotVolregParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@snapshot_volreg"]],
    "anatdataset": InputPathType,
    "epidataset": InputPathType,
    "jname": typing.NotRequired[str | None],
    "xdisplay": typing.NotRequired[str | None],
})
VSnapshotVolregParametersTagged = typing.TypedDict('VSnapshotVolregParametersTagged', {
    "@type": typing.Literal["afni/@snapshot_volreg"],
    "anatdataset": InputPathType,
    "epidataset": InputPathType,
    "jname": typing.NotRequired[str | None],
    "xdisplay": typing.NotRequired[str | None],
})


class VSnapshotVolregOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSnapshotVolregParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_jpeg: OutputPathType | None
    """JPEG image showing the edges of the EPI dataset overlayed on the
    anatomical dataset"""


def v__snapshot_volreg_params(
    anatdataset: InputPathType,
    epidataset: InputPathType,
    jname: str | None = None,
    xdisplay: str | None = None,
) -> VSnapshotVolregParametersTagged:
    """
    Build parameters.
    
    Args:
        anatdataset: Anatomical dataset file.
        epidataset: EPI dataset file.
        jname: Name for the output JPEG file.
        xdisplay: Display number of an already running Xvfb instance.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@snapshot_volreg",
        "anatdataset": anatdataset,
        "epidataset": epidataset,
    }
    if jname is not None:
        params["jname"] = jname
    if xdisplay is not None:
        params["xdisplay"] = xdisplay
    return params


def v__snapshot_volreg_cargs(
    params: VSnapshotVolregParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@snapshot_volreg")
    cargs.append(execution.input_file(params.get("anatdataset", None)))
    cargs.append(execution.input_file(params.get("epidataset", None)))
    if params.get("jname", None) is not None:
        cargs.append(params.get("jname", None))
    if params.get("xdisplay", None) is not None:
        cargs.append(params.get("xdisplay", None))
    return cargs


def v__snapshot_volreg_outputs(
    params: VSnapshotVolregParameters,
    execution: Execution,
) -> VSnapshotVolregOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSnapshotVolregOutputs(
        root=execution.output_file("."),
        output_jpeg=execution.output_file(params.get("jname", None) + ".jpg") if (params.get("jname") is not None) else None,
    )
    return ret


def v__snapshot_volreg_execute(
    params: VSnapshotVolregParameters,
    runner: Runner | None = None,
) -> VSnapshotVolregOutputs:
    """
    @snapshot_volreg
    
    Create a JPEG image showing the edges of an EPI dataset overlayed on an
    anatomical dataset to judge 3D registration quality.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSnapshotVolregOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SNAPSHOT_VOLREG_METADATA)
    params = execution.params(params)
    cargs = v__snapshot_volreg_cargs(params, execution)
    ret = v__snapshot_volreg_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__snapshot_volreg(
    anatdataset: InputPathType,
    epidataset: InputPathType,
    jname: str | None = None,
    xdisplay: str | None = None,
    runner: Runner | None = None,
) -> VSnapshotVolregOutputs:
    """
    @snapshot_volreg
    
    Create a JPEG image showing the edges of an EPI dataset overlayed on an
    anatomical dataset to judge 3D registration quality.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        anatdataset: Anatomical dataset file.
        epidataset: EPI dataset file.
        jname: Name for the output JPEG file.
        xdisplay: Display number of an already running Xvfb instance.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSnapshotVolregOutputs`).
    """
    params = v__snapshot_volreg_params(
        anatdataset=anatdataset,
        epidataset=epidataset,
        jname=jname,
        xdisplay=xdisplay,
    )
    return v__snapshot_volreg_execute(params, runner)


__all__ = [
    "VSnapshotVolregOutputs",
    "V__SNAPSHOT_VOLREG_METADATA",
    "v__snapshot_volreg",
    "v__snapshot_volreg_execute",
    "v__snapshot_volreg_params",
]
