# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SPHARM_EXAMPLES_METADATA = Metadata(
    id="5cd459e94bc6d1e20183d3aa7e19374116713404.boutiques",
    name="@Spharm.examples",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSpharmExamplesParameters = typing.TypedDict('VSpharmExamplesParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@Spharm.examples"]],
    "help_web": bool,
    "help_web_alias": bool,
    "help_view": bool,
    "help_view_alias": bool,
    "all_opts": bool,
    "help_find": typing.NotRequired[str | None],
})
VSpharmExamplesParametersTagged = typing.TypedDict('VSpharmExamplesParametersTagged', {
    "@type": typing.Literal["afni/@Spharm.examples"],
    "help_web": bool,
    "help_web_alias": bool,
    "help_view": bool,
    "help_view_alias": bool,
    "all_opts": bool,
    "help_find": typing.NotRequired[str | None],
})


class VSpharmExamplesOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSpharmExamplesParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""


def v__spharm_examples_params(
    help_web: bool = False,
    help_web_alias: bool = False,
    help_view: bool = False,
    help_view_alias: bool = False,
    all_opts: bool = False,
    help_find: str | None = None,
) -> VSpharmExamplesParametersTagged:
    """
    Build parameters.
    
    Args:
        help_web: Open webpage with help for this program.
        help_web_alias: Same as -h_web.
        help_view: Open -help output in a GUI editor.
        help_view_alias: Same as -h_view.
        all_opts: List all of the options for this script.
        help_find: Search for lines containing WORD in -help output. Search is\
            approximate.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@Spharm.examples",
        "help_web": help_web,
        "help_web_alias": help_web_alias,
        "help_view": help_view,
        "help_view_alias": help_view_alias,
        "all_opts": all_opts,
    }
    if help_find is not None:
        params["help_find"] = help_find
    return params


def v__spharm_examples_cargs(
    params: VSpharmExamplesParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@Spharm.examples")
    if params.get("help_web", False):
        cargs.append("-h_web")
    if params.get("help_web_alias", False):
        cargs.append("-hweb")
    if params.get("help_view", False):
        cargs.append("-h_view")
    if params.get("help_view_alias", False):
        cargs.append("-hview")
    if params.get("all_opts", False):
        cargs.append("-all_opts")
    if params.get("help_find", None) is not None:
        cargs.extend([
            "-h_find",
            params.get("help_find", None)
        ])
    return cargs


def v__spharm_examples_outputs(
    params: VSpharmExamplesParameters,
    execution: Execution,
) -> VSpharmExamplesOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSpharmExamplesOutputs(
        root=execution.output_file("."),
    )
    return ret


def v__spharm_examples_execute(
    params: VSpharmExamplesParameters,
    runner: Runner | None = None,
) -> VSpharmExamplesOutputs:
    """
    @Spharm.examples
    
    A script to demonstrate the usage of spherical harmonics decomposition with
    SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSpharmExamplesOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SPHARM_EXAMPLES_METADATA)
    params = execution.params(params)
    cargs = v__spharm_examples_cargs(params, execution)
    ret = v__spharm_examples_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__spharm_examples(
    help_web: bool = False,
    help_web_alias: bool = False,
    help_view: bool = False,
    help_view_alias: bool = False,
    all_opts: bool = False,
    help_find: str | None = None,
    runner: Runner | None = None,
) -> VSpharmExamplesOutputs:
    """
    @Spharm.examples
    
    A script to demonstrate the usage of spherical harmonics decomposition with
    SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        help_web: Open webpage with help for this program.
        help_web_alias: Same as -h_web.
        help_view: Open -help output in a GUI editor.
        help_view_alias: Same as -h_view.
        all_opts: List all of the options for this script.
        help_find: Search for lines containing WORD in -help output. Search is\
            approximate.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSpharmExamplesOutputs`).
    """
    params = v__spharm_examples_params(
        help_web=help_web,
        help_web_alias=help_web_alias,
        help_view=help_view,
        help_view_alias=help_view_alias,
        all_opts=all_opts,
        help_find=help_find,
    )
    return v__spharm_examples_execute(params, runner)


__all__ = [
    "VSpharmExamplesOutputs",
    "V__SPHARM_EXAMPLES_METADATA",
    "v__spharm_examples",
    "v__spharm_examples_execute",
    "v__spharm_examples_params",
]
