# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__STATAUXCODE_METADATA = Metadata(
    id="f249ed207b146f32e78b50fa7123b4ea024d66ee.boutiques",
    name="@statauxcode",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VStatauxcodeParameters = typing.TypedDict('VStatauxcodeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@statauxcode"]],
    "code": str,
})
VStatauxcodeParametersTagged = typing.TypedDict('VStatauxcodeParametersTagged', {
    "@type": typing.Literal["afni/@statauxcode"],
    "code": str,
})


class VStatauxcodeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VStatauxcodeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output: OutputPathType
    """Output file containing the result of the conversion"""


def v__statauxcode_params(
    code_: str,
) -> VStatauxcodeParametersTagged:
    """
    Build parameters.
    
    Args:
        code_: The statistical code or its numerical equivalent to be\
            converted.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@statauxcode",
        "code": code_,
    }
    return params


def v__statauxcode_cargs(
    params: VStatauxcodeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@statauxcode")
    cargs.append(params.get("code", None))
    return cargs


def v__statauxcode_outputs(
    params: VStatauxcodeParameters,
    execution: Execution,
) -> VStatauxcodeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VStatauxcodeOutputs(
        root=execution.output_file("."),
        output=execution.output_file("output.txt"),
    )
    return ret


def v__statauxcode_execute(
    params: VStatauxcodeParameters,
    runner: Runner | None = None,
) -> VStatauxcodeOutputs:
    """
    @statauxcode
    
    Returns the name or number of a statistics code based on specified mappings.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VStatauxcodeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__STATAUXCODE_METADATA)
    params = execution.params(params)
    cargs = v__statauxcode_cargs(params, execution)
    ret = v__statauxcode_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__statauxcode(
    code_: str,
    runner: Runner | None = None,
) -> VStatauxcodeOutputs:
    """
    @statauxcode
    
    Returns the name or number of a statistics code based on specified mappings.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        code_: The statistical code or its numerical equivalent to be\
            converted.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VStatauxcodeOutputs`).
    """
    params = v__statauxcode_params(
        code_=code_,
    )
    return v__statauxcode_execute(params, runner)


__all__ = [
    "VStatauxcodeOutputs",
    "V__STATAUXCODE_METADATA",
    "v__statauxcode",
    "v__statauxcode_execute",
    "v__statauxcode_params",
]
