# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_ACKNOWLEDGE_METADATA = Metadata(
    id="aada5991d565a7c2894f48b6deea6439ce86c1de.boutiques",
    name="@suma_acknowledge",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaAcknowledgeParameters = typing.TypedDict('VSumaAcknowledgeParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@suma_acknowledge"]],
    "input_file": InputPathType,
    "surface_file": InputPathType,
    "output_prefix": str,
    "center_flag": bool,
    "subsurface_file": typing.NotRequired[str | None],
    "scale_factor": typing.NotRequired[float | None],
    "reduce_factor": typing.NotRequired[float | None],
})
VSumaAcknowledgeParametersTagged = typing.TypedDict('VSumaAcknowledgeParametersTagged', {
    "@type": typing.Literal["afni/@suma_acknowledge"],
    "input_file": InputPathType,
    "surface_file": InputPathType,
    "output_prefix": str,
    "center_flag": bool,
    "subsurface_file": typing.NotRequired[str | None],
    "scale_factor": typing.NotRequired[float | None],
    "reduce_factor": typing.NotRequired[float | None],
})


class VSumaAcknowledgeOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSumaAcknowledgeParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_file: OutputPathType
    """Output graph dataset"""


def v__suma_acknowledge_params(
    input_file: InputPathType,
    surface_file: InputPathType,
    output_prefix: str,
    center_flag: bool = False,
    subsurface_file: str | None = None,
    scale_factor: float | None = None,
    reduce_factor: float | None = None,
) -> VSumaAcknowledgeParametersTagged:
    """
    Build parameters.
    
    Args:
        input_file: Required input text file with format for each line: first\
            last groupname.
        surface_file: Required surface to place nodes.
        output_prefix: Output prefix for graph dataset.
        center_flag: Put center coord at x,y,z=0,0,0. Otherwise, uses average\
            xyz in surface.
        subsurface_file: Surface for surrounding members of group (use ld2,\
            ld4, ld5, ld6, .... default is ld5).
        scale_factor: Scale xyz for group nodes (default is 1.0).
        reduce_factor: Scale xyz offsets for member nodes (xyz/r), default is\
            10.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@suma_acknowledge",
        "input_file": input_file,
        "surface_file": surface_file,
        "output_prefix": output_prefix,
        "center_flag": center_flag,
    }
    if subsurface_file is not None:
        params["subsurface_file"] = subsurface_file
    if scale_factor is not None:
        params["scale_factor"] = scale_factor
    if reduce_factor is not None:
        params["reduce_factor"] = reduce_factor
    return params


def v__suma_acknowledge_cargs(
    params: VSumaAcknowledgeParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@suma_acknowledge")
    cargs.extend([
        "-input",
        execution.input_file(params.get("input_file", None))
    ])
    cargs.extend([
        "-surf",
        execution.input_file(params.get("surface_file", None))
    ])
    cargs.extend([
        "-prefix",
        params.get("output_prefix", None)
    ])
    if params.get("center_flag", False):
        cargs.append("-center")
    if params.get("subsurface_file", None) is not None:
        cargs.extend([
            "-subsurf",
            params.get("subsurface_file", None)
        ])
    if params.get("scale_factor", None) is not None:
        cargs.extend([
            "-scalefactor",
            str(params.get("scale_factor", None))
        ])
    if params.get("reduce_factor", None) is not None:
        cargs.extend([
            "-reducefactor",
            str(params.get("reduce_factor", None))
        ])
    return cargs


def v__suma_acknowledge_outputs(
    params: VSumaAcknowledgeParameters,
    execution: Execution,
) -> VSumaAcknowledgeOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaAcknowledgeOutputs(
        root=execution.output_file("."),
        output_file=execution.output_file(params.get("output_prefix", None) + "_graph_dataset"),
    )
    return ret


def v__suma_acknowledge_execute(
    params: VSumaAcknowledgeParameters,
    runner: Runner | None = None,
) -> VSumaAcknowledgeOutputs:
    """
    @suma_acknowledge
    
    Demo script to create a graph dataset to show names of individuals and
    groups, potentially useful for acknowledgements in a talk.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaAcknowledgeOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_ACKNOWLEDGE_METADATA)
    params = execution.params(params)
    cargs = v__suma_acknowledge_cargs(params, execution)
    ret = v__suma_acknowledge_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_acknowledge(
    input_file: InputPathType,
    surface_file: InputPathType,
    output_prefix: str,
    center_flag: bool = False,
    subsurface_file: str | None = None,
    scale_factor: float | None = None,
    reduce_factor: float | None = None,
    runner: Runner | None = None,
) -> VSumaAcknowledgeOutputs:
    """
    @suma_acknowledge
    
    Demo script to create a graph dataset to show names of individuals and
    groups, potentially useful for acknowledgements in a talk.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        input_file: Required input text file with format for each line: first\
            last groupname.
        surface_file: Required surface to place nodes.
        output_prefix: Output prefix for graph dataset.
        center_flag: Put center coord at x,y,z=0,0,0. Otherwise, uses average\
            xyz in surface.
        subsurface_file: Surface for surrounding members of group (use ld2,\
            ld4, ld5, ld6, .... default is ld5).
        scale_factor: Scale xyz for group nodes (default is 1.0).
        reduce_factor: Scale xyz offsets for member nodes (xyz/r), default is\
            10.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaAcknowledgeOutputs`).
    """
    params = v__suma_acknowledge_params(
        input_file=input_file,
        surface_file=surface_file,
        output_prefix=output_prefix,
        center_flag=center_flag,
        subsurface_file=subsurface_file,
        scale_factor=scale_factor,
        reduce_factor=reduce_factor,
    )
    return v__suma_acknowledge_execute(params, runner)


__all__ = [
    "VSumaAcknowledgeOutputs",
    "V__SUMA_ACKNOWLEDGE_METADATA",
    "v__suma_acknowledge",
    "v__suma_acknowledge_execute",
    "v__suma_acknowledge_params",
]
