# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_FSVOL_TO_BRIK_METADATA = Metadata(
    id="67ffbfb1c41a26dac3811235a2de927d197e7174.boutiques",
    name="@SUMA_FSvolToBRIK",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaFsvolToBrikParameters = typing.TypedDict('VSumaFsvolToBrikParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@SUMA_FSvolToBRIK"]],
    "fs_vol_data": InputPathType,
    "prefix": str,
})
VSumaFsvolToBrikParametersTagged = typing.TypedDict('VSumaFsvolToBrikParametersTagged', {
    "@type": typing.Literal["afni/@SUMA_FSvolToBRIK"],
    "fs_vol_data": InputPathType,
    "prefix": str,
})


class VSumaFsvolToBrikOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSumaFsvolToBrikParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    out_brik: OutputPathType
    """Output BRIK volume converted from FreeSurfer data"""
    out_head: OutputPathType
    """Header file for the output BRIK volume"""


def v__suma_fsvol_to_brik_params(
    fs_vol_data: InputPathType,
    prefix: str,
) -> VSumaFsvolToBrikParametersTagged:
    """
    Build parameters.
    
    Args:
        fs_vol_data: Input FreeSurfer volume data (e.g. COR- images or .mgz\
            volume).
        prefix: Prefix for output BRIK volume.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@SUMA_FSvolToBRIK",
        "fs_vol_data": fs_vol_data,
        "prefix": prefix,
    }
    return params


def v__suma_fsvol_to_brik_cargs(
    params: VSumaFsvolToBrikParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_FSvolToBRIK")
    cargs.append(execution.input_file(params.get("fs_vol_data", None)))
    cargs.append(params.get("prefix", None))
    return cargs


def v__suma_fsvol_to_brik_outputs(
    params: VSumaFsvolToBrikParameters,
    execution: Execution,
) -> VSumaFsvolToBrikOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaFsvolToBrikOutputs(
        root=execution.output_file("."),
        out_brik=execution.output_file(params.get("prefix", None) + ".BRIK"),
        out_head=execution.output_file(params.get("prefix", None) + ".HEAD"),
    )
    return ret


def v__suma_fsvol_to_brik_execute(
    params: VSumaFsvolToBrikParameters,
    runner: Runner | None = None,
) -> VSumaFsvolToBrikOutputs:
    """
    @SUMA_FSvolToBRIK
    
    A script to convert COR- or .mgz files from FreeSurfer to BRIK format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaFsvolToBrikOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_FSVOL_TO_BRIK_METADATA)
    params = execution.params(params)
    cargs = v__suma_fsvol_to_brik_cargs(params, execution)
    ret = v__suma_fsvol_to_brik_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_fsvol_to_brik(
    fs_vol_data: InputPathType,
    prefix: str,
    runner: Runner | None = None,
) -> VSumaFsvolToBrikOutputs:
    """
    @SUMA_FSvolToBRIK
    
    A script to convert COR- or .mgz files from FreeSurfer to BRIK format.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        fs_vol_data: Input FreeSurfer volume data (e.g. COR- images or .mgz\
            volume).
        prefix: Prefix for output BRIK volume.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaFsvolToBrikOutputs`).
    """
    params = v__suma_fsvol_to_brik_params(
        fs_vol_data=fs_vol_data,
        prefix=prefix,
    )
    return v__suma_fsvol_to_brik_execute(params, runner)


__all__ = [
    "VSumaFsvolToBrikOutputs",
    "V__SUMA_FSVOL_TO_BRIK_METADATA",
    "v__suma_fsvol_to_brik",
    "v__suma_fsvol_to_brik_execute",
    "v__suma_fsvol_to_brik_params",
]
