# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_MAKE_SPEC_CARET_METADATA = Metadata(
    id="feaa100c7c92cb262519c13b181c1cebc4b05816.boutiques",
    name="@SUMA_Make_Spec_Caret",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaMakeSpecCaretParameters = typing.TypedDict('VSumaMakeSpecCaretParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@SUMA_Make_Spec_Caret"]],
    "subject_id": str,
    "help": bool,
    "debug": typing.NotRequired[int | None],
    "echo": bool,
    "surface_path": typing.NotRequired[str | None],
    "side_labels_style": typing.NotRequired[int | None],
})
VSumaMakeSpecCaretParametersTagged = typing.TypedDict('VSumaMakeSpecCaretParametersTagged', {
    "@type": typing.Literal["afni/@SUMA_Make_Spec_Caret"],
    "subject_id": str,
    "help": bool,
    "debug": typing.NotRequired[int | None],
    "echo": bool,
    "surface_path": typing.NotRequired[str | None],
    "side_labels_style": typing.NotRequired[int | None],
})


class VSumaMakeSpecCaretOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSumaMakeSpecCaretParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    left_hemisphere_spec: OutputPathType
    """Output spec file for the left hemisphere"""
    right_hemisphere_spec: OutputPathType
    """Output spec file for the right hemisphere"""


def v__suma_make_spec_caret_params(
    subject_id: str,
    help_: bool = False,
    debug: int | None = None,
    echo: bool = False,
    surface_path: str | None = None,
    side_labels_style: int | None = None,
) -> VSumaMakeSpecCaretParametersTagged:
    """
    Build parameters.
    
    Args:
        subject_id: Subject ID for file naming.
        help_: Show help information.
        debug: Print debug information along the way.
        echo: Turn shell echo on.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        side_labels_style: Naming style for Left, Right sides. Allowed values:\
            1 for L R LR style (default), 2 for LEFT RIGHT LR style, 3 for A B AB.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@SUMA_Make_Spec_Caret",
        "subject_id": subject_id,
        "help": help_,
        "echo": echo,
    }
    if debug is not None:
        params["debug"] = debug
    if surface_path is not None:
        params["surface_path"] = surface_path
    if side_labels_style is not None:
        params["side_labels_style"] = side_labels_style
    return params


def v__suma_make_spec_caret_cargs(
    params: VSumaMakeSpecCaretParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_Make_Spec_Caret")
    cargs.extend([
        "-sid",
        params.get("subject_id", None)
    ])
    if params.get("help", False):
        cargs.append("-help")
    if params.get("debug", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug", None))
        ])
    if params.get("echo", False):
        cargs.append("-echo")
    if params.get("surface_path", None) is not None:
        cargs.extend([
            "-sfpath",
            params.get("surface_path", None)
        ])
    if params.get("side_labels_style", None) is not None:
        cargs.extend([
            "-side_labels_style",
            str(params.get("side_labels_style", None))
        ])
    return cargs


def v__suma_make_spec_caret_outputs(
    params: VSumaMakeSpecCaretParameters,
    execution: Execution,
) -> VSumaMakeSpecCaretOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaMakeSpecCaretOutputs(
        root=execution.output_file("."),
        left_hemisphere_spec=execution.output_file(params.get("subject_id", None) + "_lh.spec"),
        right_hemisphere_spec=execution.output_file(params.get("subject_id", None) + "_rh.spec"),
    )
    return ret


def v__suma_make_spec_caret_execute(
    params: VSumaMakeSpecCaretParameters,
    runner: Runner | None = None,
) -> VSumaMakeSpecCaretOutputs:
    """
    @SUMA_Make_Spec_Caret
    
    Prepare surfaces for viewing in SUMA, tested with Caret-5.2 surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecCaretOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_MAKE_SPEC_CARET_METADATA)
    params = execution.params(params)
    cargs = v__suma_make_spec_caret_cargs(params, execution)
    ret = v__suma_make_spec_caret_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_make_spec_caret(
    subject_id: str,
    help_: bool = False,
    debug: int | None = None,
    echo: bool = False,
    surface_path: str | None = None,
    side_labels_style: int | None = None,
    runner: Runner | None = None,
) -> VSumaMakeSpecCaretOutputs:
    """
    @SUMA_Make_Spec_Caret
    
    Prepare surfaces for viewing in SUMA, tested with Caret-5.2 surfaces.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        subject_id: Subject ID for file naming.
        help_: Show help information.
        debug: Print debug information along the way.
        echo: Turn shell echo on.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        side_labels_style: Naming style for Left, Right sides. Allowed values:\
            1 for L R LR style (default), 2 for LEFT RIGHT LR style, 3 for A B AB.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecCaretOutputs`).
    """
    params = v__suma_make_spec_caret_params(
        subject_id=subject_id,
        help_=help_,
        debug=debug,
        echo=echo,
        surface_path=surface_path,
        side_labels_style=side_labels_style,
    )
    return v__suma_make_spec_caret_execute(params, runner)


__all__ = [
    "VSumaMakeSpecCaretOutputs",
    "V__SUMA_MAKE_SPEC_CARET_METADATA",
    "v__suma_make_spec_caret",
    "v__suma_make_spec_caret_execute",
    "v__suma_make_spec_caret_params",
]
