# This file was auto generated by Styx.
# Do not edit this file directly.

import typing
import pathlib
from styxdefs import *

V__SUMA_MAKE_SPEC_SF_METADATA = Metadata(
    id="2e386638a118532e0161e64bba78fad27856fccb.boutiques",
    name="@SUMA_Make_Spec_SF",
    package="afni",
    container_image_tag="afni/afni_make_build:AFNI_24.2.06",
)


VSumaMakeSpecSfParameters = typing.TypedDict('VSumaMakeSpecSfParameters', {
    "@type": typing.NotRequired[typing.Literal["afni/@SUMA_Make_Spec_SF"]],
    "debug_level": typing.NotRequired[int | None],
    "surface_path": typing.NotRequired[str | None],
    "subject_id": str,
})
VSumaMakeSpecSfParametersTagged = typing.TypedDict('VSumaMakeSpecSfParametersTagged', {
    "@type": typing.Literal["afni/@SUMA_Make_Spec_SF"],
    "debug_level": typing.NotRequired[int | None],
    "surface_path": typing.NotRequired[str | None],
    "subject_id": str,
})


class VSumaMakeSpecSfOutputs(typing.NamedTuple):
    """
    Output object returned when calling `VSumaMakeSpecSfParameters(...)`.
    """
    root: OutputPathType
    """Output root folder. This is the root folder for all outputs."""
    output_directory: OutputPathType
    """All created files are stored in SURFACES directory"""


def v__suma_make_spec_sf_params(
    subject_id: str,
    debug_level: int | None = None,
    surface_path: str | None = None,
) -> VSumaMakeSpecSfParametersTagged:
    """
    Build parameters.
    
    Args:
        subject_id: Required subject ID for file naming.
        debug_level: Print debug information along the way.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
    Returns:
        Parameter dictionary
    """
    params = {
        "@type": "afni/@SUMA_Make_Spec_SF",
        "subject_id": subject_id,
    }
    if debug_level is not None:
        params["debug_level"] = debug_level
    if surface_path is not None:
        params["surface_path"] = surface_path
    return params


def v__suma_make_spec_sf_cargs(
    params: VSumaMakeSpecSfParameters,
    execution: Execution,
) -> list[str]:
    """
    Build command-line arguments from parameters.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Command-line arguments.
    """
    cargs = []
    cargs.append("@SUMA_Make_Spec_SF")
    if params.get("debug_level", None) is not None:
        cargs.extend([
            "-debug",
            str(params.get("debug_level", None))
        ])
    if params.get("surface_path", None) is not None:
        cargs.extend([
            "-sfpath",
            params.get("surface_path", None)
        ])
    cargs.extend([
        "-sid",
        params.get("subject_id", None)
    ])
    return cargs


def v__suma_make_spec_sf_outputs(
    params: VSumaMakeSpecSfParameters,
    execution: Execution,
) -> VSumaMakeSpecSfOutputs:
    """
    Build outputs object containing output file paths and possibly stdout/stderr.
    
    Args:
        params: The parameters.
        execution: The execution object for resolving input paths.
    Returns:
        Outputs object.
    """
    ret = VSumaMakeSpecSfOutputs(
        root=execution.output_file("."),
        output_directory=execution.output_file("SURFACES"),
    )
    return ret


def v__suma_make_spec_sf_execute(
    params: VSumaMakeSpecSfParameters,
    runner: Runner | None = None,
) -> VSumaMakeSpecSfOutputs:
    """
    @SUMA_Make_Spec_SF
    
    Prepare for surface viewing in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        params: The parameters.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecSfOutputs`).
    """
    runner = runner or get_global_runner()
    execution = runner.start_execution(V__SUMA_MAKE_SPEC_SF_METADATA)
    params = execution.params(params)
    cargs = v__suma_make_spec_sf_cargs(params, execution)
    ret = v__suma_make_spec_sf_outputs(params, execution)
    execution.run(cargs)
    return ret


def v__suma_make_spec_sf(
    subject_id: str,
    debug_level: int | None = None,
    surface_path: str | None = None,
    runner: Runner | None = None,
) -> VSumaMakeSpecSfOutputs:
    """
    @SUMA_Make_Spec_SF
    
    Prepare for surface viewing in SUMA.
    
    Author: AFNI Developers
    
    URL: https://afni.nimh.nih.gov/
    
    Args:
        subject_id: Required subject ID for file naming.
        debug_level: Print debug information along the way.
        surface_path: Path to directory containing 'SURFACES' and AFNI volume\
            used in creating the surfaces.
        runner: Command runner.
    Returns:
        NamedTuple of outputs (described in `VSumaMakeSpecSfOutputs`).
    """
    params = v__suma_make_spec_sf_params(
        debug_level=debug_level,
        surface_path=surface_path,
        subject_id=subject_id,
    )
    return v__suma_make_spec_sf_execute(params, runner)


__all__ = [
    "VSumaMakeSpecSfOutputs",
    "V__SUMA_MAKE_SPEC_SF_METADATA",
    "v__suma_make_spec_sf",
    "v__suma_make_spec_sf_execute",
    "v__suma_make_spec_sf_params",
]
